/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.AdminReader;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.EmptyDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;

public class PlainRemoteResource
implements RemoteResource {
    protected AdminContext admin = null;
    protected AttributeDescription[] attributes;
    protected Object[] values = null;
    protected boolean iscontainer = false;
    protected boolean isindexerscatalog = false;
    protected boolean isDirectoryResource = false;
    protected boolean isframed = false;
    protected String identifier = null;
    protected URL parent = null;
    protected URL url = null;
    protected RemoteResource[] frames = null;
    protected ResourceDescription description = null;

    PlainRemoteResource(AdminContext adminContext, URL uRL, String string, ResourceDescription resourceDescription) {
        this(adminContext, uRL, null, string, resourceDescription);
    }

    PlainRemoteResource(AdminContext adminContext, URL uRL, URL uRL2, String string, ResourceDescription resourceDescription) {
        this.admin = adminContext;
        this.parent = uRL;
        this.identifier = string;
        this.description = resourceDescription;
        String[] stringArray = resourceDescription.getClassesAndInterfaces();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("org.w3c.tools.resources.ContainerInterface")) {
                this.iscontainer = true;
            }
            if (stringArray[n].equals("org.w3c.tools.resources.FramedResource")) {
                this.isframed = true;
            }
            if (stringArray[n].equals("org.w3c.tools.resources.DirectoryResource")) {
                this.isDirectoryResource = true;
            }
            if (stringArray[n].equals("org.w3c.tools.resources.indexer.IndexersCatalog")) {
                this.isindexerscatalog = true;
            }
            ++n;
        }
        if (uRL2 == null) {
            if (uRL != null) {
                String string2 = string == null ? string : URLEncoder.encode(string);
                String string3 = this.iscontainer ? String.valueOf(string2) + "/" : string2;
                try {
                    this.url = string != null ? new URL(String.valueOf(uRL.toString()) + string3) : uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    this.url = null;
                }
            } else {
                this.url = null;
            }
        } else {
            this.url = uRL2;
        }
        this.createRemoteFrames();
    }

    protected void createRemoteFrames() {
        ResourceDescription[] resourceDescriptionArray = this.description.getFrameDescriptions();
        int n = resourceDescriptionArray.length;
        this.frames = new RemoteResource[n];
        int n2 = 0;
        while (n2 < n) {
            ResourceDescription resourceDescription = resourceDescriptionArray[n2];
            String string = resourceDescription.getIdentifier();
            URL uRL = null;
            try {
                uRL = this.isFrame() ? new URL(this.url, String.valueOf(this.url.getFile()) + "?" + string) : new URL(String.valueOf(this.parent.toString()) + this.identifier + "?" + string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                uRL = null;
            }
            PlainRemoteResource plainRemoteResource = new PlainRemoteResource(this.admin, this.parent, uRL, string, resourceDescription);
            this.frames[n2] = plainRemoteResource;
            ++n2;
        }
    }

    protected Request createRequest() {
        Request request = this.admin.http.createRequest();
        request.setURL(this.url);
        request.setValue("TE", "gzip");
        return request;
    }

    public void delete() throws RemoteAccessException {
        try {
            Request request = this.createRequest();
            request.setMethod("DELETE-RESOURCE");
            request.setContentType(AdminContext.conftype);
            Reply reply = this.admin.runRequest(request);
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public void dump(PrintStream printStream) throws RemoteAccessException {
        System.out.println("+ classes: ");
        String[] stringArray = this.getClassHierarchy();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("\t" + stringArray[n]);
            ++n;
        }
        if (this.isframed && this.frames != null) {
            System.out.println("+ " + this.frames.length + " frames.");
            int n2 = 0;
            while (n2 < this.frames.length) {
                printStream.println("\t" + ((PlainRemoteResource)this.frames[n2]).identifier);
                ((PlainRemoteResource)this.frames[n2]).dump(printStream);
                ++n2;
            }
        }
        System.out.println("+ attributes: ");
        AttributeDescription[] attributeDescriptionArray = this.getAttributes();
        int n3 = 0;
        while (n3 < attributeDescriptionArray.length) {
            Attribute attribute = attributeDescriptionArray[n3].getAttribute();
            if (attribute.checkFlag(2)) {
                Object object = attributeDescriptionArray[n3].getValue();
                if (object != null) {
                    Attribute attribute2;
                    if (attribute instanceof SimpleAttribute) {
                        attribute2 = (SimpleAttribute)attribute;
                        printStream.println("\t" + attribute.getName() + "=" + ((SimpleAttribute)attribute2).pickle(attributeDescriptionArray[n3].getValue()));
                    } else if (attribute instanceof ArrayAttribute) {
                        attribute2 = (ArrayAttribute)attribute;
                        String[] stringArray2 = ((ArrayAttribute)attribute2).pickle(attributeDescriptionArray[n3].getValue());
                        printStream.print("\t" + attribute.getName() + "=");
                        int n4 = 0;
                        while (n4 < stringArray2.length) {
                            if (n4 != 0) {
                                printStream.print(" | ");
                            }
                            printStream.print(stringArray2[n4]);
                            ++n4;
                        }
                    }
                } else {
                    printStream.println("\t" + attribute.getName() + " <undef>");
                }
            }
            ++n3;
        }
    }

    public String[] enumerateResourceIdentifiers() throws RemoteAccessException {
        if (!this.iscontainer) {
            throw new RuntimeException("not a container");
        }
        try {
            return this.description.getChildren();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException("http " + exception.getMessage());
        }
    }

    public synchronized AttributeDescription[] getAttributes() throws RemoteAccessException {
        return this.description.getAttributeDescriptions();
    }

    public String[] getClassHierarchy() throws RemoteAccessException {
        return this.description.getClassHierarchy();
    }

    public RemoteResource[] getFrames() throws RemoteAccessException {
        if (!this.isframed) {
            throw new RuntimeException("not a framed resource");
        }
        return this.frames;
    }

    protected InputStream getInputStream(Reply reply) throws IOException {
        if (reply.hasTransferEncoding("gzip")) {
            return new GZIPInputStream(reply.getInputStream());
        }
        return reply.getInputStream();
    }

    public Object getValue(String string) throws RemoteAccessException {
        if (string.equals("identifier")) {
            return this.identifier;
        }
        String[] stringArray = new String[]{string};
        return this.getValues(stringArray)[0];
    }

    public Object[] getValues(String[] stringArray) throws RemoteAccessException {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            AttributeDescription attributeDescription = this.lookupAttribute(stringArray[n]);
            objectArray[n] = attributeDescription != null ? attributeDescription.getValue() : null;
            ++n;
        }
        return objectArray;
    }

    public boolean isContainer() throws RemoteAccessException {
        if (this.identifier != null) {
            String string;
            if (this.identifier.equals("root")) {
                return false;
            }
            if (this.identifier.equals("control") && (string = this.getClassHierarchy()[0]).equals("org.w3c.jigsaw.http.ControlResource")) {
                return false;
            }
        }
        return this.iscontainer;
    }

    public boolean isDirectoryResource() throws RemoteAccessException {
        if (this.identifier != null && this.identifier.equals("root")) {
            return false;
        }
        return this.isDirectoryResource;
    }

    public boolean isFrame() {
        return this.isFrameURL(this.url);
    }

    protected boolean isFrameURL(URL uRL) {
        return uRL.toString().lastIndexOf(63) != -1;
    }

    public boolean isFramed() throws RemoteAccessException {
        return this.isframed;
    }

    public boolean isIndexersCatalog() throws RemoteAccessException {
        return this.isindexerscatalog;
    }

    public RemoteResource loadResource(String string) throws RemoteAccessException {
        try {
            Request request = this.createRequest();
            request.setMethod("LOAD-RESOURCE");
            request.setContentType(AdminContext.conftype);
            request.setURL(new URL(String.valueOf(this.url.toString()) + URLEncoder.encode(string)));
            Reply reply = this.admin.runRequest(request);
            InputStream inputStream = this.getInputStream(reply);
            RemoteResource remoteResource = this.admin.reader.readResource(this.url, string, inputStream);
            inputStream.close();
            return remoteResource;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    protected AttributeDescription lookupAttribute(String string) {
        AttributeDescription[] attributeDescriptionArray = this.description.getAttributeDescriptions();
        int n = 0;
        while (n < attributeDescriptionArray.length) {
            AttributeDescription attributeDescription = attributeDescriptionArray[n];
            if (attributeDescription.getName().equals(string)) {
                return attributeDescription;
            }
            ++n;
        }
        return null;
    }

    public RemoteResource registerFrame(String string, String string2) throws RemoteAccessException {
        if (!this.isframed) {
            throw new RuntimeException("not a framed resource");
        }
        try {
            Request request = this.createRequest();
            request.setMethod("REGISTER-FRAME");
            request.setContentType(AdminContext.conftype);
            ResourceDescription resourceDescription = new EmptyDescription(string2, string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.admin.writer.writeResourceDescription(resourceDescription, gZIPOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            request.setContentLength(byArray.length);
            request.addTransferEncoding("gzip");
            request.setOutputStream(new ByteArrayInputStream(byArray));
            Reply reply = this.admin.runRequest(request);
            AdminReader cfr_ignored_0 = this.admin.reader;
            resourceDescription = AdminReader.readResourceDescription(this.getInputStream(reply));
            string = resourceDescription.getIdentifier();
            URL uRL = null;
            uRL = this.isFrame() ? new URL(this.url, String.valueOf(this.url.getFile()) + "?" + string) : new URL(String.valueOf(this.parent.toString()) + this.identifier + "?" + string);
            PlainRemoteResource plainRemoteResource = new PlainRemoteResource(this.admin, this.parent, uRL, string, resourceDescription);
            if (this.frames != null) {
                RemoteResource[] remoteResourceArray = new RemoteResource[this.frames.length + 1];
                System.arraycopy(this.frames, 0, remoteResourceArray, 0, this.frames.length);
                remoteResourceArray[this.frames.length] = plainRemoteResource;
                this.frames = remoteResourceArray;
            } else {
                this.frames = new RemoteResource[1];
                this.frames[0] = plainRemoteResource;
            }
            return plainRemoteResource;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public RemoteResource registerResource(String string, String string2) throws RemoteAccessException {
        ResourceDescription resourceDescription = new EmptyDescription(string2, string);
        try {
            Request request = this.createRequest();
            request.setMethod("REGISTER-RESOURCE");
            request.setContentType(AdminContext.conftype);
            request.setURL(this.url);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.admin.writer.writeResourceDescription(resourceDescription, gZIPOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            request.setContentLength(byArray.length);
            request.addTransferEncoding("gzip");
            request.setOutputStream(new ByteArrayInputStream(byArray));
            Reply reply = this.admin.runRequest(request);
            AdminReader cfr_ignored_0 = this.admin.reader;
            resourceDescription = AdminReader.readResourceDescription(this.getInputStream(reply));
            PlainRemoteResource plainRemoteResource = new PlainRemoteResource(this.admin, this.url, resourceDescription.getIdentifier(), resourceDescription);
            return plainRemoteResource;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public void reindex() throws RemoteAccessException {
        if (this.isDirectoryResource()) {
            try {
                Request request = this.createRequest();
                request.setMethod("REINDEX-RESOURCE");
                request.setContentType(AdminContext.conftype);
                Reply reply = this.admin.runRequest(request);
            }
            catch (RemoteAccessException remoteAccessException) {
                throw remoteAccessException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RemoteAccessException(exception.getMessage());
            }
        } else {
            throw new RemoteAccessException("Error, can't reindex! This is not a DirectoryResource.");
        }
    }

    protected void setFrames(RemoteResource[] remoteResourceArray) {
        this.isframed = true;
        this.frames = remoteResourceArray;
    }

    public void setValue(String string, Object object) throws RemoteAccessException {
        String[] stringArray = new String[1];
        Object[] objectArray = new Object[1];
        stringArray[0] = string;
        objectArray[0] = object;
        this.setValues(stringArray, objectArray);
    }

    public void setValues(String[] stringArray, Object[] objectArray) throws RemoteAccessException {
        block9: {
            Object object;
            Object object2;
            Object object3;
            String string = null;
            boolean bl = false;
            AttributeDescription[] attributeDescriptionArray = new AttributeDescription[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                object3 = this.lookupAttribute(stringArray[n]);
                if (object3 != null) {
                    ((AttributeDescription)object3).setValue(objectArray[n]);
                    attributeDescriptionArray[n] = object3;
                }
                if (stringArray[n].equals("identifier")) {
                    bl = true;
                    string = (String)objectArray[n];
                }
                ++n;
            }
            object3 = this.description.getClone(attributeDescriptionArray);
            try {
                object2 = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object2);
                this.admin.writer.writeResourceDescription((ResourceDescription)object3, gZIPOutputStream);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                Request request = this.createRequest();
                request.setMethod("SET-VALUES");
                request.setContentType(AdminContext.conftype);
                request.setContentLength(((byte[])object).length);
                request.addTransferEncoding("gzip");
                request.setOutputStream(new ByteArrayInputStream((byte[])object));
                Reply reply = this.admin.runRequest(request);
            }
            catch (RemoteAccessException remoteAccessException) {
                throw remoteAccessException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RemoteAccessException("exception " + exception.getMessage());
            }
            if (!bl) break block9;
            this.identifier = new String(string);
            try {
                if (!this.isFrame()) {
                    this.url = this.iscontainer ? new URL(String.valueOf(this.parent.toString()) + this.identifier + "/") : new URL(String.valueOf(this.parent.toString()) + this.identifier);
                    this.updateURL(new URL(String.valueOf(this.parent.toString()) + this.identifier));
                    break block9;
                }
                object2 = this.url.getFile();
                int n2 = ((String)object2).lastIndexOf(63);
                object = ((String)object2).substring(0, n2);
                this.updateURL(new URL(this.url, (String)object));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    public void unregisterFrame(RemoteResource remoteResource) throws RemoteAccessException {
        RemoteResource[] remoteResourceArray;
        if (!this.isframed) {
            throw new RuntimeException("not a framed resource");
        }
        if (this.frames == null) {
            throw new RuntimeException("this resource has no frames");
        }
        String string = null;
        try {
            string = ((PlainRemoteResource)remoteResource).identifier;
            remoteResourceArray = this.createRequest();
            remoteResourceArray.setMethod("UNREGISTER-FRAME");
            remoteResourceArray.setContentType(AdminContext.conftype);
            remoteResourceArray.setURL(this.url);
            EmptyDescription emptyDescription = new EmptyDescription("", string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.admin.writer.writeResourceDescription(emptyDescription, gZIPOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            remoteResourceArray.setContentLength(byArray.length);
            remoteResourceArray.addTransferEncoding("gzip");
            remoteResourceArray.setOutputStream(new ByteArrayInputStream(byArray));
            Reply reply = this.admin.runRequest((Request)remoteResourceArray);
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
        remoteResourceArray = new RemoteResource[this.frames.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.frames.length) {
            if (((PlainRemoteResource)this.frames[n2]).identifier.equals(string)) {
                System.arraycopy(this.frames, n2 + 1, remoteResourceArray, n, this.frames.length - n2 - 1);
                this.frames = remoteResourceArray;
                return;
            }
            try {
                remoteResourceArray[n++] = this.frames[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
            ++n2;
        }
    }

    protected void update() throws RemoteAccessException {
        try {
            Request request = this.createRequest();
            request.setMethod("LOAD-RESOURCE");
            request.setContentType(AdminContext.conftype);
            Reply reply = this.admin.runRequest(request);
            InputStream inputStream = this.getInputStream(reply);
            AdminReader cfr_ignored_0 = this.admin.reader;
            this.description = AdminReader.readResourceDescription(inputStream);
            this.createRemoteFrames();
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public void updateURL(URL uRL) {
        if (this.isFrame()) {
            try {
                this.url = new URL(uRL, String.valueOf(uRL.getFile()) + "?" + this.identifier);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        if (this.frames != null) {
            int n = 0;
            while (n < this.frames.length) {
                this.frames[n].updateURL(this.url);
                ++n;
            }
        }
    }
}

