/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.AdminProtocolException;
import org.w3c.jigsaw.admin.AdminReader;
import org.w3c.jigsaw.admin.AdminServer;
import org.w3c.jigsaw.admin.AdminWriter;
import org.w3c.jigsaw.admin.ResourceBroker;
import org.w3c.jigsaw.daemon.ServerHandler;
import org.w3c.jigsaw.daemon.ServerHandlerManager;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;

public class BrokerFrame
extends HTTPFrame {
    protected ResourceBroker broker = null;
    protected AdminWriter writer = null;
    protected ServerHandlerManager shm = null;
    protected AdminServer admin = null;

    public BrokerFrame(ServerHandlerManager serverHandlerManager, AdminServer adminServer, AdminWriter adminWriter) {
        this.shm = serverHandlerManager;
        this.admin = adminServer;
        this.writer = adminWriter;
    }

    protected void checkContentType(Request request) throws ProtocolException {
        if (request.getContentType().match(AdminContext.conftype) < 0) {
            this.error(request, "invalid MIME type: " + request.getContentType());
        }
    }

    protected void error(Request request, String string) throws ProtocolException {
        Reply reply = request.makeReply(500);
        reply.setContent(string);
        throw new HTTPException(reply);
    }

    public Reply extended(Request request) throws ProtocolException, ResourceException {
        String string = request.getMethod();
        if (string.equals("SET-VALUES")) {
            this.checkContentType(request);
            return this.remoteSetValues(request);
        }
        if (string.equals("LOAD-RESOURCE")) {
            this.checkContentType(request);
            return this.remoteLoadResource(request);
        }
        if (string.equals("REGISTER-RESOURCE")) {
            this.checkContentType(request);
            return this.remoteRegisterResource(request);
        }
        if (string.equals("DELETE-RESOURCE")) {
            this.checkContentType(request);
            return this.remoteDeleteResource(request);
        }
        if (string.equals("REINDEX-RESOURCE")) {
            this.checkContentType(request);
            return this.remoteReindexResource(request);
        }
        if (string.equals("UNREGISTER-FRAME")) {
            this.checkContentType(request);
            return this.remoteUnregisterFrame(request);
        }
        if (string.equals("REGISTER-FRAME")) {
            this.checkContentType(request);
            return this.remoteRegisterFrame(request);
        }
        return super.extended(request);
    }

    protected InputStream getInputStream(Request request) throws ProtocolException {
        Client client = request.getClient();
        if (client != null) {
            try {
                client.sendContinue();
            }
            catch (IOException iOException) {
                throw new HTTPException(iOException.getMessage());
            }
        }
        try {
            if (request.hasTransferEncoding("gzip")) {
                return new GZIPInputStream(request.getInputStream());
            }
            return request.getInputStream();
        }
        catch (IOException iOException) {
            this.error(request, "invalid request");
            return null;
        }
    }

    protected Reply getOtherResource(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method GET not implemented.<br><br>The administration server does not use plain HTTP but a variant of it. The only tool available for now is an application called <b>JigAdmin</b>. Please read the documentation.");
        throw new HTTPException(reply);
    }

    public ResourceReference lookup(Request request) throws ProtocolException {
        block35: {
            ResourceReference resourceReference;
            block36: {
                Object object;
                String string;
                LookupFrameState lookupFrameState;
                Object object2;
                LookupState lookupState = null;
                try {
                    lookupState = new LookupState(request);
                }
                catch (ProtocolException protocolException) {
                    protocolException.printStackTrace();
                    throw new HTTPException(protocolException);
                }
                LookupResult lookupResult = new LookupResult(null);
                resourceReference = null;
                lookupState.markInternal();
                if (!lookupState.hasMoreComponents()) {
                    return this.admin.getRootReference();
                }
                String string2 = lookupState.getNextComponent();
                ServerHandler serverHandler = this.shm.lookupServerHandler(string2);
                if (serverHandler == null) {
                    if (string2.equals("realms")) {
                        resourceReference = this.admin.getRealmCatalogResource();
                    } else if (string2.equals("control")) {
                        resourceReference = this.admin.getControlResource();
                    } else {
                        this.error(request, "unknown server handler");
                    }
                } else {
                    resourceReference = serverHandler.getConfigResource();
                }
                if (resourceReference == null) break block35;
                ResourceReference resourceReference2 = null;
                while (lookupState.hasMoreComponents()) {
                    try {
                        try {
                            if (resourceReference == null) {
                                this.error(request, "url too long");
                            }
                            if (!((object2 = resourceReference.lock()) instanceof ContainerInterface)) {
                                this.error(request, "url too long");
                            }
                            resourceReference2 = ((ContainerInterface)object2).lookup(lookupState.getNextComponent());
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            this.error(request, "unable to restore resource");
                        }
                        lookupFrameState = null;
                        resourceReference.unlock();
                        resourceReference = resourceReference2;
                    }
                    catch (Throwable throwable) {
                        lookupFrameState = null;
                        resourceReference.unlock();
                        resourceReference = resourceReference2;
                        throw throwable;
                    }
                }
                if (resourceReference == null) {
                    this.error(request, "unknown resource");
                }
                if ((string = request.getQueryString()) == null) break block36;
                try {
                    try {
                        object = resourceReference.lock();
                        if (!(object instanceof FramedResource)) {
                            this.error(request, "not a framed resource");
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        this.error(request, "unable to restore resource");
                    }
                    object2 = null;
                    resourceReference.unlock();
                }
                catch (Throwable throwable) {
                    object2 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
                lookupFrameState = new LookupFrameState(string);
                object2 = null;
                object = resourceReference;
                ResourceReference[] resourceReferenceArray = null;
                while (lookupFrameState.hasMoreComponents()) {
                    ResourceFrame resourceFrame;
                    try {
                        try {
                            resourceReferenceArray = ((FramedResource)object.lock()).getFramesReference();
                            if (resourceReferenceArray == null) {
                                this.error(request, "unknown frame");
                            }
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            this.error(request, invalidResourceException.getMessage());
                        }
                        resourceFrame = null;
                        object.unlock();
                    }
                    catch (Throwable throwable) {
                        resourceFrame = null;
                        object.unlock();
                        throw throwable;
                    }
                    object = null;
                    object2 = lookupFrameState.getNextComponent();
                    ResourceReference resourceReference3 = null;
                    resourceFrame = null;
                    int n = 0;
                    while (n < resourceReferenceArray.length) {
                        Object var17_21;
                        resourceReference3 = resourceReferenceArray[n];
                        try {
                            try {
                                resourceFrame = (ResourceFrame)resourceReference3.lock();
                                if (resourceFrame.getIdentifier().equals(object2)) {
                                    object = resourceReference3;
                                    var17_21 = null;
                                    resourceReference3.unlock();
                                    break;
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                this.error(request, invalidResourceException.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            var17_21 = null;
                            resourceReference3.unlock();
                            throw throwable;
                        }
                        var17_21 = null;
                        resourceReference3.unlock();
                        ++n;
                    }
                    if (object != null) continue;
                    this.error(request, "unknown frame");
                }
                return object;
            }
            return resourceReference;
        }
        this.error(request, "unknown resource");
        return null;
    }

    protected Reply okReply(Request request) {
        return this.okReply(request, null);
    }

    protected Reply okReply(Request request, byte[] byArray) {
        Reply reply = request.makeReply(200);
        reply.setContentType(AdminContext.conftype);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            reply.setContentLength(byArray.length);
            reply.setStream(byteArrayInputStream);
        }
        return reply;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        if (framedResource instanceof ResourceBroker) {
            this.broker = (ResourceBroker)framedResource;
        }
    }

    public Reply remoteDeleteResource(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (resource != null) {
                    try {
                        resource.delete();
                    }
                    catch (MultipleLockException multipleLockException) {
                        this.error(request, multipleLockException.getMessage());
                    }
                    Reply reply = this.okReply(request);
                    Object var5_6 = null;
                    resourceReference.unlock();
                    return reply;
                }
                this.error(request, "Bad request");
            }
            catch (InvalidResourceException invalidResourceException) {
                this.error(request, "Invalid resource");
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var5_7 = null;
        resourceReference.unlock();
        return null;
    }

    public Reply remoteLoadResource(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                Resource resource = resourceReference.lock();
                this.writer.writeResource(resource, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                this.error(request, "bad request");
            }
            catch (InvalidResourceException invalidResourceException) {
                this.error(request, "Invalid resource");
            }
            catch (AdminProtocolException adminProtocolException) {
                this.error(request, adminProtocolException.getMessage());
            }
            Object var5_6 = null;
            resourceReference.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            resourceReference.unlock();
            throw throwable;
        }
        return this.okReply(request, byteArrayOutputStream.toByteArray());
    }

    public Reply remoteRegisterFrame(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (!(resource instanceof FramedResource)) {
                    this.error(request, "can't add frame to non-framed resource");
                }
                try {
                    InputStream inputStream = this.getInputStream(request);
                    ResourceDescription resourceDescription = AdminReader.readResourceDescription(inputStream);
                    String string = resourceDescription.getClassName();
                    String string2 = resourceDescription.getIdentifier();
                    ResourceFrame resourceFrame = null;
                    try {
                        resourceFrame = (ResourceFrame)Class.forName(string).newInstance();
                    }
                    catch (Exception exception) {
                        this.error(request, "invalid frame class " + string);
                    }
                    Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
                    if (string2 != null && !string2.equals("")) {
                        hashtable.put("identifier", string2);
                    }
                    ((FramedResource)resource).registerFrame(resourceFrame, hashtable);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.writer.writeResource(resourceFrame, byteArrayOutputStream);
                    Reply reply = this.okReply(request, byteArrayOutputStream.toByteArray());
                    Object var5_13 = null;
                    resourceReference.unlock();
                    return reply;
                }
                catch (IOException iOException) {
                    this.error(request, "bad request");
                }
                catch (AdminProtocolException adminProtocolException) {
                    this.error(request, adminProtocolException.getMessage());
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                this.error(request, "invalid resource");
            }
        }
        catch (Throwable throwable) {
            Object var5_15 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var5_14 = null;
        resourceReference.unlock();
        return null;
    }

    public Reply remoteRegisterResource(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (!(resource instanceof ContainerInterface)) {
                    this.error(request, "can't add child in non-container");
                }
                try {
                    InputStream inputStream = this.getInputStream(request);
                    ResourceDescription resourceDescription = AdminReader.readResourceDescription(inputStream);
                    String string = resourceDescription.getClassName();
                    String string2 = resourceDescription.getIdentifier();
                    Resource resource2 = null;
                    try {
                        resource2 = (Resource)Class.forName(string).newInstance();
                    }
                    catch (Exception exception) {
                        this.error(request, "invalid resource class " + string);
                    }
                    try {
                        ((ContainerInterface)((Object)resource)).registerResource(string2, resource2, null);
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        this.error(request, invalidResourceException.getMessage());
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.writer.writeResource(resource2, byteArrayOutputStream);
                    Reply reply = this.okReply(request, byteArrayOutputStream.toByteArray());
                    Object var5_13 = null;
                    resourceReference.unlock();
                    return reply;
                }
                catch (IOException iOException) {
                    this.error(request, "bad request");
                }
                catch (AdminProtocolException adminProtocolException) {
                    this.error(request, adminProtocolException.getMessage());
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                this.error(request, "Invalid resource");
            }
        }
        catch (Throwable throwable) {
            Object var5_15 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var5_14 = null;
        resourceReference.unlock();
        return null;
    }

    public Reply remoteReindexResource(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (resource != null) {
                    if (resource instanceof DirectoryResource) {
                        DirectoryResource directoryResource = (DirectoryResource)resource;
                        directoryResource.reindex();
                        Reply reply = this.okReply(request);
                        Object var5_6 = null;
                        resourceReference.unlock();
                        return reply;
                    }
                    this.error(request, "Can't reindex this resource(not a DirectoryResource)");
                } else {
                    this.error(request, "Bad request");
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                this.error(request, "Invalid resource");
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var5_7 = null;
        resourceReference.unlock();
        return null;
    }

    public Reply remoteSetValues(Request request) throws ProtocolException {
        InputStream inputStream = this.getInputStream(request);
        ResourceReference resourceReference = this.lookup(request);
        try {
            try {
                Resource resource = resourceReference.lock();
                ResourceDescription resourceDescription = AdminReader.readResourceDescription(inputStream);
                AttributeDescription[] attributeDescriptionArray = resourceDescription.getAttributeDescriptions();
                int n = 0;
                while (n < attributeDescriptionArray.length) {
                    AttributeDescription attributeDescription = attributeDescriptionArray[n];
                    resource.setValue(attributeDescription.getName(), attributeDescription.getValue());
                    ++n;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                this.error(request, "Invalid resource");
            }
            catch (IOException iOException) {
                this.error(request, "bad request");
            }
            catch (AdminProtocolException adminProtocolException) {
                this.error(request, adminProtocolException.getMessage());
            }
            Object var5_11 = null;
            resourceReference.unlock();
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            resourceReference.unlock();
            throw throwable;
        }
        return this.okReply(request);
    }

    public Reply remoteUnregisterFrame(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (!(resource instanceof FramedResource)) {
                    this.error(request, "Can't unregister frames from a non-framed resource");
                }
                try {
                    InputStream inputStream = this.getInputStream(request);
                    ResourceDescription resourceDescription = AdminReader.readResourceDescription(inputStream);
                    String string = resourceDescription.getIdentifier();
                    ResourceFrame[] resourceFrameArray = ((FramedResource)resource).getFrames();
                    int n = 0;
                    while (n < resourceFrameArray.length) {
                        if (resourceFrameArray[n].getIdentifier().equals(string)) {
                            ((FramedResource)resource).unregisterFrame(resourceFrameArray[n]);
                            Reply reply = this.okReply(request);
                            Object var5_11 = null;
                            resourceReference.unlock();
                            return reply;
                        }
                        ++n;
                    }
                    this.error(request, "Frame " + string + " not registered");
                }
                catch (IOException iOException) {
                    this.error(request, "bad request");
                }
                catch (AdminProtocolException adminProtocolException) {
                    this.error(request, adminProtocolException.getMessage());
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                this.error(request, "invalid resource");
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var5_12 = null;
        resourceReference.unlock();
        return null;
    }

    class LookupFrameState {
        private int index;
        private String[] components;

        LookupFrameState(String string) {
            this.parseQuery(string);
        }

        public final String getNextComponent() {
            return this.components[this.index++];
        }

        public boolean hasMoreComponents() {
            return this.index < this.components.length;
        }

        void parseQuery(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "?");
            int n = stringTokenizer.countTokens();
            this.components = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.components[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            this.index = 0;
        }
    }
}

