/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.gui.AuthPopup;
import org.w3c.jigadm.gui.ServerMenu;
import org.w3c.jigadm.gui.TreeListener;
import org.w3c.jigadm.gui.UrlPopup;
import org.w3c.jigadm.gui.WindowCloser;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.MessagePopup;
import org.w3c.tools.widgets.NodeHandler;
import org.w3c.tools.widgets.TreeBrowser;
import org.w3c.tools.widgets.TreeNode;

public class ServerBrowser
extends TreeBrowser
implements NodeHandler {
    public static final boolean debug = false;
    Image diricon = null;
    Image diropenedicon = null;
    Image fileicon = null;
    AdminContext admin = null;
    TreeListener tl = null;
    TreeNode lastn = null;
    RemoteResourceWrapper rootResource;
    boolean locked;
    private Frame popup = null;

    public ServerBrowser(Frame frame, TreeListener treeListener) {
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        this.tl = treeListener;
        this.diricon = this.getImage(propertyManager.getIconLocation("smalldir"));
        this.fileicon = this.getImage(propertyManager.getIconLocation("smallfile"));
        this.diropenedicon = this.getImage(propertyManager.getIconLocation("smalldiropened"));
        new UrlPopup("Open Admin Server : ", this, frame, false);
    }

    public ServerBrowser(AdminContext adminContext, TreeListener treeListener) {
        boolean bl = false;
        RemoteResource remoteResource = null;
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        this.admin = adminContext;
        this.tl = treeListener;
        this.locked = false;
        this.diricon = this.getImage(propertyManager.getIconLocation("smalldir"));
        this.fileicon = this.getImage(propertyManager.getIconLocation("smallfile"));
        this.diropenedicon = this.getImage(propertyManager.getIconLocation("smalldiropened"));
        while (!bl) {
            Object var7_6;
            try {
                try {
                    bl = true;
                    adminContext.initialize();
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    remoteAccessException.printStackTrace();
                }
                var7_6 = null;
                if (bl) continue;
                this.popupDialog("admin");
            }
            catch (Throwable throwable) {
                var7_6 = null;
                if (!bl) {
                    this.popupDialog("admin");
                }
                throw throwable;
            }
        }
        try {
            remoteResource = adminContext.getAdminResource();
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
            System.exit(0);
        }
        this.rootResource = new RemoteResourceWrapper(remoteResource, this);
        this.initialize(this.rootResource, "Root", this, this.diricon);
    }

    protected void dispose(boolean bl) {
        if (!bl) {
            Frame frame = this.getFrame(this);
            if (frame != null) {
                frame.dispose();
            }
            this.popup.dispose();
            if (--WindowCloser.windows < 0) {
                System.exit(0);
            }
        } else if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    protected void errorPopup(String string, Exception exception) {
        new MessagePopup(String.valueOf(string) + " : " + exception.getMessage()).show();
    }

    private final Frame getFrame(Component component) {
        while (!(component instanceof Frame)) {
            if ((component = component.getParent()) != null) continue;
            return null;
        }
        return (Frame)component;
    }

    private final Image getImage(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        return image;
    }

    protected synchronized boolean getLock() {
        if (this.locked) {
            return false;
        }
        this.setCursor(3);
        this.locked = true;
        return true;
    }

    protected RemoteResourceWrapper getResources(RemoteResourceWrapper remoteResourceWrapper, String string) {
        RemoteResource remoteResource = null;
        if (remoteResourceWrapper != null) {
            try {
                remoteResource = remoteResourceWrapper.getResource().loadResource(string);
            }
            catch (RemoteAccessException remoteAccessException) {
                this.errorPopup("RemoteAccessException", remoteAccessException);
                remoteAccessException.printStackTrace();
            }
        }
        return new RemoteResourceWrapper(remoteResourceWrapper, remoteResource, this);
    }

    public RemoteResourceWrapper getRootWrapper() {
        return this.rootResource;
    }

    public void insertNode(RemoteResourceWrapper remoteResourceWrapper, RemoteResourceWrapper remoteResourceWrapper2, String string) {
        TreeNode treeNode;
        boolean bl = false;
        if (remoteResourceWrapper == null) {
            System.out.println("Error null father");
        }
        if ((treeNode = this.getNode(remoteResourceWrapper)).getChildren() == -1) {
            return;
        }
        if (treeNode == null) {
            return;
        }
        try {
            bl = remoteResourceWrapper2.getResource().isContainer();
        }
        catch (RemoteAccessException remoteAccessException) {
            this.errorPopup("RemoteAccessException", remoteAccessException);
        }
        if (bl) {
            this.insert(treeNode, remoteResourceWrapper2, this, string, this.diricon);
        } else {
            this.insert(treeNode, remoteResourceWrapper2, this, string, this.fileicon);
        }
        this.repaint();
    }

    public boolean isDirectory(TreeBrowser treeBrowser, TreeNode treeNode) {
        RemoteResourceWrapper remoteResourceWrapper = null;
        boolean bl = false;
        remoteResourceWrapper = (RemoteResourceWrapper)treeNode.getItem();
        if (remoteResourceWrapper == null) {
            return false;
        }
        try {
            return remoteResourceWrapper.getResource().isContainer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-root")) {
                serializable = System.getProperties();
                string2 = stringArray[++n];
                ((Hashtable)serializable).put(PropertyManager.ROOT_P, string2);
                System.setProperties((Properties)serializable);
            }
            string = stringArray[n];
            ++n;
        }
        try {
            serializable = new Frame("Server Browser: " + string);
            ((Component)serializable).setBackground(Color.lightGray);
            Panel panel = new Panel();
            Panel panel2 = new Panel(new BorderLayout());
            TreeListener treeListener = new TreeListener(panel);
            ServerBrowser serverBrowser = null;
            Scrollbar scrollbar = new Scrollbar(1);
            Scrollbar scrollbar2 = new Scrollbar(0);
            try {
                AdminContext adminContext = new AdminContext(new URL(string));
                serverBrowser = new ServerBrowser(adminContext, treeListener);
                serverBrowser.setVerticalScrollbar(scrollbar);
                serverBrowser.setHorizontalScrollbar(scrollbar2);
                panel2.add("Center", serverBrowser);
                panel2.add("East", scrollbar);
                panel2.add("South", scrollbar2);
                panel.setLayout(new BorderLayout());
                ServerMenu serverMenu = new ServerMenu(serverBrowser);
                GridLayout gridLayout = new GridLayout(1, 2);
                ((Container)serializable).setLayout(gridLayout);
                ((Frame)serializable).setMenuBar(serverMenu);
                ((Container)serializable).add(panel2);
                ((Container)serializable).add(panel);
                ((Component)serializable).setSize(new Dimension(850, 600));
                ((Window)serializable).addWindowListener(new WindowCloser((Frame)serializable));
                ((Window)serializable).show();
            }
            catch (MalformedURLException malformedURLException) {
                serverBrowser = new ServerBrowser((Frame)serializable, treeListener);
                serverBrowser.setVerticalScrollbar(scrollbar);
                serverBrowser.setHorizontalScrollbar(scrollbar2);
                panel2.add("Center", serverBrowser);
                panel2.add("East", scrollbar);
                panel2.add("South", scrollbar2);
                panel.setLayout(new BorderLayout());
                ServerMenu serverMenu = new ServerMenu(serverBrowser);
                GridLayout gridLayout = new GridLayout(1, 2);
                ((Container)serializable).setLayout(gridLayout);
                ((Frame)serializable).setMenuBar(serverMenu);
                ((Container)serializable).add(panel2);
                ((Container)serializable).add(panel);
                ((Component)serializable).setSize(new Dimension(850, 600));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void notifyCollapse(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.getLock()) {
            if (this.tl != null) {
                this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
            }
            treeBrowser.collapse(treeNode);
            if (!treeNode.equals(this.lastn)) {
                treeBrowser.unselect(this.lastn);
                this.lastn = null;
            }
            this.unlock();
            treeBrowser.repaint();
            treeNode.setIcon(this.diricon);
        }
    }

    public void notifyExecute(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
        }
        if (!treeNode.equals(this.lastn)) {
            treeBrowser.unselect(this.lastn);
            this.lastn = null;
        }
        treeBrowser.repaint();
    }

    public void notifyExpand(TreeBrowser treeBrowser, TreeNode treeNode) {
        new Expander(treeBrowser, treeNode).start();
    }

    public void notifyExpander(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
        }
        RemoteResourceWrapper remoteResourceWrapper = null;
        RemoteResource remoteResource = null;
        boolean bl = false;
        remoteResourceWrapper = (RemoteResourceWrapper)treeNode.getItem();
        if (remoteResourceWrapper == null) {
            return;
        }
        remoteResource = remoteResourceWrapper.getResource();
        try {
            bl = remoteResource.isContainer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            String[] stringArray = null;
            this.setCursor(3);
            boolean bl2 = false;
            while (!bl2) {
                Object var9_9;
                bl2 = true;
                try {
                    try {
                        stringArray = remoteResource.enumerateResourceIdentifiers();
                    }
                    catch (RemoteAccessException remoteAccessException) {
                        if (remoteAccessException.getMessage().equals("Unauthorized")) {
                            bl2 = false;
                        }
                        stringArray = new String[]{};
                        this.errorPopup("RemoteAccessException", remoteAccessException);
                        remoteAccessException.printStackTrace();
                    }
                    var9_9 = null;
                    if (bl2) continue;
                    this.popupDialog("admin");
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    if (!bl2) {
                        this.popupDialog("admin");
                    }
                    throw throwable;
                }
            }
            Sorter.sortStringArray(stringArray, true);
            int n = 0;
            while (n < stringArray.length) {
                boolean bl3 = false;
                RemoteResourceWrapper remoteResourceWrapper2 = this.getResources(remoteResourceWrapper, stringArray[n]);
                RemoteResource remoteResource2 = remoteResourceWrapper2.getResource();
                try {
                    bl3 = remoteResource2.isContainer();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bl3) {
                    treeBrowser.insert(treeNode, remoteResourceWrapper2, this, stringArray[n], this.diricon);
                } else {
                    treeBrowser.insert(treeNode, remoteResourceWrapper2, this, stringArray[n], this.fileicon);
                }
                ++n;
            }
            if (!treeNode.equals(this.lastn)) {
                treeBrowser.unselect(this.lastn);
                this.lastn = null;
            }
            this.setCursor(0);
            treeBrowser.repaint();
        }
        if (this.isDirectory(this, treeNode)) {
            treeNode.setIcon(this.diropenedicon);
        }
    }

    public void notifySelect(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.editedChanged(this, (RemoteResourceWrapper)treeNode.getItem());
        }
        treeBrowser.unselect(this.lastn);
        treeBrowser.select(treeNode);
        treeBrowser.repaint();
        this.lastn = treeNode;
    }

    protected void open(AdminContext adminContext) {
        RemoteResource remoteResource = null;
        this.admin = adminContext;
        this.locked = false;
        boolean bl = false;
        if (this.rootResource != null) {
            this.removeNode(this.rootResource);
        }
        this.tl.focusChanged(null);
        while (!bl) {
            Object var5_4;
            try {
                try {
                    bl = true;
                    adminContext.initialize();
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    remoteAccessException.printStackTrace();
                }
                var5_4 = null;
                if (bl) continue;
                this.popupDialog("admin");
            }
            catch (Throwable throwable) {
                var5_4 = null;
                if (!bl) {
                    this.popupDialog("admin");
                }
                throw throwable;
            }
        }
        try {
            remoteResource = adminContext.getAdminResource();
        }
        catch (RemoteAccessException remoteAccessException) {
            this.errorPopup("RemoteAccessException", remoteAccessException);
            return;
        }
        this.rootResource = new RemoteResourceWrapper(remoteResource, this);
        this.initialize(this.rootResource, "Root", this, this.diricon);
        this.tl.focusChanged(this.rootResource);
        this.repaint();
    }

    public void popupDialog(String string) {
        if (this.popup == null) {
            AuthPopup authPopup = new AuthPopup(this, string);
            this.popup = new Frame("Authorization for jigadm");
            ((Component)this.popup).setBackground(Color.lightGray);
            ((Component)this.popup).setSize(new Dimension(300, 200));
            this.popup.setLayout(new BorderLayout());
            this.popup.add("Center", authPopup);
            this.popup.show();
            authPopup.user.requestFocus();
            while (!authPopup.waitForCompletion()) {
            }
        }
    }

    public void removeNode(RemoteResourceWrapper remoteResourceWrapper) {
        if (this.getLock()) {
            if (this.getNode(remoteResourceWrapper) != null) {
                this.removeBranch(this.getNode(remoteResourceWrapper));
                this.tl.nodeRemoved(remoteResourceWrapper);
            }
            this.unlock();
            this.repaint();
        }
    }

    public void renameNode(RemoteResourceWrapper remoteResourceWrapper, String string) {
        TreeNode treeNode;
        try {
            if (remoteResourceWrapper.getResource().isContainer()) {
                new MessagePopup("WARNING: you have changed the identifier. To access the sons, close and reopen the node").show();
            }
        }
        catch (RemoteAccessException remoteAccessException) {}
        if ((treeNode = this.getNode(remoteResourceWrapper)) != null) {
            treeNode.setLabel(string);
            this.repaint();
        }
    }

    public void setCursor(int n) {
        ((Component)this.getFrame(this)).setCursor(new Cursor(n));
        Toolkit.getDefaultToolkit().sync();
    }

    protected synchronized void unlock() {
        this.locked = false;
        this.setCursor(0);
    }

    class Expander
    extends Thread {
        TreeBrowser browser;
        TreeNode nd;

        Expander(TreeBrowser treeBrowser, TreeNode treeNode) {
            this.browser = treeBrowser;
            this.nd = treeNode;
        }

        public void run() {
            if (ServerBrowser.this.getLock()) {
                ServerBrowser.this.notifyExpander(this.browser, this.nd);
                ServerBrowser.this.unlock();
            }
        }
    }
}

