/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Properties;
import java.util.Vector;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.ResourceEditorInterface;
import org.w3c.jigadm.editors.ResourceHelper;
import org.w3c.jigadm.editors.ResourceHelperFactory;
import org.w3c.jigadm.events.ResourceChangeEvent;
import org.w3c.jigadm.events.ResourceListener;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.widgets.BorderPanel;
import org.w3c.tools.widgets.MessagePopup;

public class ResourceEditor
implements ResourceEditorInterface {
    public static final String UNREMOVABLE_P = "unremovable";
    protected Vector rls = null;
    Panel target = null;
    Panel buttonp = null;
    Panel editorp = null;
    Button commitb = null;
    Button resetb;
    RemoteResource rr = null;
    RemoteResourceWrapper rrw = null;
    ResourceHelper[] rh = null;
    protected Button[] b = null;
    protected Label message = null;
    Properties p;
    protected static final String DELETE_L = "Delete";
    protected static final String REINDEX_L = "Reindex";

    public ResourceEditor(Panel panel) {
        this.target = panel;
    }

    public synchronized void addResourceListener(ResourceListener resourceListener) {
        if (this.rls == null) {
            this.rls = new Vector(2);
        }
        this.rls.addElement(resourceListener);
    }

    public void clearChanged() {
        int n = 0;
        while (n < this.rh.length) {
            if (this.rh[n].hasChanged()) {
                this.rh[n].clearChanged();
            }
            ++n;
        }
    }

    public void commitChanges() throws RemoteAccessException {
        int n = 0;
        while (n < this.rh.length) {
            if (this.rh[n].hasChanged()) {
                boolean bl = false;
                while (!bl) {
                    Object var4_3;
                    try {
                        try {
                            bl = true;
                            this.rh[n].commitChanges();
                        }
                        catch (RemoteAccessException remoteAccessException) {
                            if (remoteAccessException.getMessage().equals("Unauthorized")) {
                                bl = false;
                            }
                            new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
                            throw remoteAccessException;
                        }
                        var4_3 = null;
                        if (bl) continue;
                        this.rrw.getBrowser().popupDialog("admin");
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        if (!bl) {
                            this.rrw.getBrowser().popupDialog("admin");
                        }
                        throw throwable;
                    }
                }
            }
            ++n;
        }
    }

    protected void delete() {
        boolean bl = false;
        while (!bl) {
            Object var3_2;
            try {
                try {
                    bl = true;
                    this.rrw.getResource().delete();
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
                }
                var3_2 = null;
                if (bl) continue;
                this.rrw.getBrowser().popupDialog("admin");
            }
            catch (Throwable throwable) {
                var3_2 = null;
                if (!bl) {
                    this.rrw.getBrowser().popupDialog("admin");
                }
                throw throwable;
            }
        }
        this.processEvent(new ResourceChangeEvent(this.rrw.getFatherWrapper(), "deleted", this.rrw, null));
    }

    public RemoteResource getValue() {
        return this.rr;
    }

    public boolean hasChanged() {
        int n = 0;
        while (n < this.rh.length) {
            if (this.rh[n].hasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Properties properties) throws RemoteAccessException {
        int n = 0;
        this.rrw = remoteResourceWrapper;
        this.rr = remoteResourceWrapper.getResource();
        ButtonBarListener buttonBarListener = new ButtonBarListener();
        this.p = properties;
        this.target.removeAll();
        BorderPanel borderPanel = new BorderPanel(4, 2);
        borderPanel.setLayout(new BorderLayout());
        this.rh = ResourceHelperFactory.getHelpers(remoteResourceWrapper);
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        Properties properties2 = propertyManager.getEditorProperties(remoteResourceWrapper);
        if (properties2 == null || properties2.getProperty(UNREMOVABLE_P, "false").equalsIgnoreCase("false")) {
            MouseButtonListener mouseButtonListener = new MouseButtonListener();
            Panel panel = new Panel(new BorderLayout());
            Button button = new Button(DELETE_L);
            button.addActionListener(buttonBarListener);
            button.addMouseListener(mouseButtonListener);
            panel.add("West", button);
            this.message = new Label("", 1);
            this.message.setBackground(Color.gray);
            this.message.setForeground(Color.white);
            BorderPanel borderPanel2 = new BorderPanel(3, 2);
            borderPanel2.setLayout(new BorderLayout());
            borderPanel2.add(this.message);
            panel.add("Center", borderPanel2);
            if (this.rr.isDirectoryResource()) {
                Button button2 = new Button(REINDEX_L);
                button2.addActionListener(buttonBarListener);
                button2.addMouseListener(mouseButtonListener);
                panel.add("East", button2);
            }
            borderPanel.add("South", panel);
        }
        if (this.rh != null) {
            this.buttonp = new BorderPanel(4, 1);
            this.buttonp.setLayout(new GridLayout(1, this.rh.length + 1));
            this.b = new Button[this.rh.length];
            int n2 = 0;
            while (n2 < this.rh.length) {
                this.b[n2] = new Button(this.rh[n2].getTitle());
                this.buttonp.add(this.b[n2]);
                this.b[n2].addActionListener(buttonBarListener);
                if (this.rh[n2].getTitle().equalsIgnoreCase("shortcut")) {
                    n = n2;
                }
                ++n2;
            }
            this.editorp = new Panel(new BorderLayout());
            borderPanel.add("North", this.buttonp);
            borderPanel.add("Center", this.editorp);
            this.target.add("Center", borderPanel);
            this.target.validate();
            this.target.setVisible(true);
            this.switchHelper(this.b[n]);
        } else {
            this.target.add("Center", borderPanel);
            this.target.validate();
            this.target.setVisible(true);
        }
    }

    protected void processEvent(EventObject eventObject) {
        Vector vector = null;
        ResourceEditor resourceEditor = this;
        synchronized (resourceEditor) {
            if (this.rls == null || !(eventObject instanceof ResourceChangeEvent)) {
                Object var5_5 = null;
                return;
            }
            vector = (Vector)this.rls.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ResourceListener resourceListener = (ResourceListener)vector.elementAt(n);
            resourceListener.resourceChanged((ResourceChangeEvent)eventObject);
            ++n;
        }
    }

    protected void reindex() {
        boolean bl = false;
        while (!bl) {
            Object var3_2;
            try {
                try {
                    bl = true;
                    this.rrw.getResource().reindex();
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
                }
                var3_2 = null;
                if (bl) continue;
                this.rrw.getBrowser().popupDialog("admin");
            }
            catch (Throwable throwable) {
                var3_2 = null;
                if (!bl) {
                    this.rrw.getBrowser().popupDialog("admin");
                }
                throw throwable;
            }
        }
    }

    public synchronized void removeResourceListener(ResourceListener resourceListener) {
        if (this.rls != null) {
            this.rls.removeElement(resourceListener);
        }
    }

    public void resetChanges() throws RemoteAccessException {
        int n = 0;
        while (n < this.rh.length) {
            if (this.rh[n].hasChanged()) {
                this.rh[n].resetChanges();
            }
            ++n;
        }
    }

    public void setMessage(String string) {
        this.message.setText(string);
    }

    protected void switchHelper(Button button) throws RemoteAccessException {
        int n = 0;
        while (n < this.b.length) {
            if (button.equals(this.b[n])) {
                PropertyManager propertyManager = PropertyManager.getPropertyManager();
                Properties properties = propertyManager.getHelperProperties(this.rrw, this.rh[n].getClass().getName());
                boolean bl = false;
                while (!bl) {
                    Object var7_6;
                    try {
                        try {
                            bl = true;
                            this.rh[n].initialize(this.rrw, properties);
                        }
                        catch (RemoteAccessException remoteAccessException) {
                            if (remoteAccessException.getMessage().equals("Unauthorized")) {
                                bl = false;
                            }
                            new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
                            throw remoteAccessException;
                        }
                        var7_6 = null;
                        if (bl) continue;
                        this.rrw.getBrowser().popupDialog("admin");
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        if (!bl) {
                            this.rrw.getBrowser().popupDialog("admin");
                        }
                        throw throwable;
                    }
                }
                this.editorp.setVisible(false);
                this.editorp.removeAll();
                this.editorp.add("Center", this.rh[n].getComponent());
                this.editorp.validate();
                this.editorp.setVisible(true);
            }
            ++n;
        }
    }

    class Alert
    extends Canvas {
        Image alert = null;
        int width = 0;
        int height = 0;

        Alert() {
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            String string = propertyManager.getIconLocation("alert");
            if (string != null) {
                this.alert = Toolkit.getDefaultToolkit().getImage(string);
                this.prepareImage(this.alert, this);
            }
            this.initSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.width + 8, this.height + 8);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width + 8, this.height + 8);
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            this.initSize();
            Container container = this.getParent();
            if (container != null) {
                container.doLayout();
            }
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }

        private void initSize() {
            if (this.alert != null) {
                this.width = this.alert.getWidth(this);
                this.height = this.alert.getHeight(this);
            }
        }

        public void paint(Graphics graphics) {
            if (this.alert != null) {
                graphics.drawImage(this.alert, 0, 0, this);
            }
        }
    }

    class ButtonBarListener
    implements ActionListener {
        ButtonBarListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(ResourceEditor.DELETE_L)) {
                new Deleter().start();
            } else if (actionEvent.getActionCommand().equals(ResourceEditor.REINDEX_L)) {
                ResourceEditor.this.setMessage("Reindexation started...");
                new Reindexer().start();
                ResourceEditor.this.setMessage("Reindexation done.");
            } else {
                new Switcher((Button)actionEvent.getSource()).start();
            }
        }

        class Switcher
        extends Thread {
            Button b;

            Switcher(Button button) {
                this.b = button;
            }

            public void run() {
                try {
                    ResourceEditor.this.switchHelper(this.b);
                }
                catch (RemoteAccessException remoteAccessException) {}
            }
        }

        class Deleter
        extends Thread {
            Deleter() {
            }

            public void run() {
                ResourceEditor.this.delete();
            }
        }

        class Reindexer
        extends Thread {
            Reindexer() {
            }

            public void run() {
                ResourceEditor.this.reindex();
            }
        }
    }

    class MouseButtonListener
    extends MouseAdapter {
        MouseButtonListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof Button) {
                String string = ((Button)component).getActionCommand();
                if (string.equals(ResourceEditor.DELETE_L)) {
                    ResourceEditor.this.setMessage("Delete this resource!");
                } else if (string.equals(ResourceEditor.REINDEX_L)) {
                    ResourceEditor.this.setMessage("Reindex the children.");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ResourceEditor.this.setMessage("");
        }
    }
}

