/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.cvs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.w3c.cvs.CVS;
import org.w3c.cvs.CommitHandler;
import org.w3c.cvs.CvsAddException;
import org.w3c.cvs.CvsCommitException;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.cvs.CvsUpdateException;
import org.w3c.cvs.StatusHandler;
import org.w3c.cvs.UpToDateCheckFailedException;
import org.w3c.cvs.UpdateHandler;

class CvsRunner
implements CVS {
    private static final File tmpdir = new File("/tmp");
    public static boolean debug = true;

    CvsRunner() {
    }

    void cvsAdd(CvsDirectory cvsDirectory, String[] stringArray) throws CvsException {
        this.cvsAdd(cvsDirectory, stringArray, null);
    }

    void cvsAdd(CvsDirectory cvsDirectory, String[] stringArray, String[] stringArray2) throws CvsException {
        String[] stringArray3 = new String[stringArray.length + 1];
        stringArray3[0] = "add";
        System.arraycopy(stringArray, 0, stringArray3, 1, stringArray.length);
        String[] stringArray4 = this.getCommand(cvsDirectory, null, stringArray3);
        try {
            Process process = this.runCvsProcess(stringArray4, stringArray2);
            this.readText(process.getInputStream(), null);
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsAdmin(CvsDirectory cvsDirectory, String[] stringArray) throws CvsException {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "admin";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        String[] stringArray3 = this.getCommand(cvsDirectory, null, stringArray2);
        try {
            Process process = this.runCvsProcess(stringArray3);
            this.readText(process.getInputStream(), null);
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsCommit(CvsDirectory cvsDirectory, String string, CommitHandler commitHandler) throws CvsException {
        this.cvsCommit(cvsDirectory, string, commitHandler, null);
    }

    void cvsCommit(CvsDirectory cvsDirectory, String string, CommitHandler commitHandler, String[] stringArray) throws CvsException {
        File file = this.getTemporaryFile(string);
        String[] stringArray2 = new String[]{"commit", "-F", file.getAbsolutePath()};
        String[] stringArray3 = this.getCommand(cvsDirectory, null, stringArray2);
        try {
            try {
                Process process = this.runCvsProcess(stringArray3, stringArray);
                this.parseCommitOutput(process.getInputStream(), commitHandler);
                this.waitForCompletion(process, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new CvsException(iOException.getMessage());
            }
            Object var9_10 = null;
            file.delete();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            file.delete();
            throw throwable;
        }
    }

    void cvsCommit(CvsDirectory cvsDirectory, String[] stringArray, String string, CommitHandler commitHandler) throws CvsException {
        this.cvsCommit(cvsDirectory, stringArray, string, commitHandler, null);
    }

    void cvsCommit(CvsDirectory cvsDirectory, String[] stringArray, String string, CommitHandler commitHandler, String[] stringArray2) throws CvsException {
        String[] stringArray3 = new String[stringArray.length + 3];
        File file = this.getTemporaryFile(string);
        stringArray3[0] = "commit";
        stringArray3[1] = "-F";
        stringArray3[2] = file.getAbsolutePath();
        System.arraycopy(stringArray, 0, stringArray3, 3, stringArray.length);
        String[] stringArray4 = this.getCommand(cvsDirectory, null, stringArray3);
        try {
            try {
                Process process = this.runCvsProcess(stringArray4, stringArray2);
                this.parseCommitOutput(process.getInputStream(), commitHandler);
                this.waitForCompletion(process, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new CvsException(iOException.getMessage());
            }
            Object var10_11 = null;
            file.delete();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            file.delete();
            throw throwable;
        }
    }

    String cvsDiff(CvsDirectory cvsDirectory, String string) throws CvsException {
        String[] stringArray = new String[]{"diff", string};
        String[] stringArray2 = this.getCommand(cvsDirectory, null, stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Process process = this.runCvsProcess(stringArray2);
            this.readText(process.getInputStream(), stringBuffer);
            this.waitForCompletion(process, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    void cvsGet(CvsDirectory cvsDirectory, String string) throws CvsException {
        String[] stringArray = new String[]{"get", string};
        String[] stringArray2 = this.getCommand(cvsDirectory, null, stringArray);
        try {
            Process process = this.runCvsProcess(stringArray2);
            this.readText(process.getInputStream(), null);
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsLoad(CvsDirectory cvsDirectory, String string, UpdateHandler updateHandler) throws CvsException {
        String[] stringArray = new String[]{"-n"};
        String[] stringArray2 = new String[]{"update", "-I", "!", string};
        String[] stringArray3 = this.getCommand(cvsDirectory, stringArray, stringArray2);
        try {
            Process process = this.runCvsProcess(stringArray3);
            this.parseUpdateOutput(process.getInputStream(), updateHandler);
            this.waitForCompletion(process, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsLoad(CvsDirectory cvsDirectory, String string, UpdateHandler updateHandler, StatusHandler statusHandler) throws CvsException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"-n"};
        String[] stringArray3 = new String[]{"update", "-I", "!", string};
        String[] stringArray4 = this.getCommand(cvsDirectory, stringArray2, stringArray3);
        try {
            stringArray = this.runCvsProcess(stringArray4);
            this.parseUpdateOutput(stringArray.getInputStream(), updateHandler);
            this.waitForCompletion((Process)stringArray, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
        stringArray = new String[]{"status", string};
        stringArray4 = this.getCommand(cvsDirectory, null, stringArray);
        try {
            Process process = this.runCvsProcess(stringArray4);
            this.parseStatusOutput(process.getInputStream(), statusHandler);
            this.waitForCompletion(process, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsLoad(CvsDirectory cvsDirectory, UpdateHandler updateHandler, StatusHandler statusHandler) throws CvsException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"-n"};
        String[] stringArray3 = new String[]{"update", "-I", "!", "-l"};
        String[] stringArray4 = this.getCommand(cvsDirectory, stringArray2, stringArray3);
        try {
            stringArray = this.runCvsProcess(stringArray4);
            this.parseUpdateOutput(stringArray.getInputStream(), updateHandler);
            this.waitForCompletion((Process)stringArray, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
        stringArray = new String[]{"status", "-l"};
        stringArray4 = this.getCommand(cvsDirectory, null, stringArray);
        try {
            Process process = this.runCvsProcess(stringArray4);
            this.parseStatusOutput(process.getInputStream(), statusHandler);
            this.waitForCompletion(process, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    String cvsLog(CvsDirectory cvsDirectory, String string) throws CvsException {
        String[] stringArray = new String[]{"log", string};
        String[] stringArray2 = this.getCommand(cvsDirectory, null, stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Process process = this.runCvsProcess(stringArray2);
            this.readText(process.getInputStream(), stringBuffer);
            this.waitForCompletion(process, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
        return stringBuffer.toString();
    }

    void cvsRemove(CvsDirectory cvsDirectory, String[] stringArray) throws CvsException {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "remove";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        String[] stringArray3 = this.getCommand(cvsDirectory, null, stringArray2);
        try {
            Process process = this.runCvsProcess(stringArray3);
            this.readText(process.getInputStream(), null);
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsRevert(CvsDirectory cvsDirectory, String string, String string2, File file, String[] stringArray) throws CvsException {
        try {
            this.cvsRevert(cvsDirectory, string, string2, new FileOutputStream(file), stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsRevert(CvsDirectory cvsDirectory, String string, String string2, OutputStream outputStream, String[] stringArray) throws CvsException {
        String[] stringArray2 = new String[]{"update", "-p", "-r", string2, string};
        String[] stringArray3 = this.getCommand(cvsDirectory, null, stringArray2);
        try {
            Process process = this.runCvsProcess(stringArray3, stringArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            byte[] byArray = new byte[4096];
            try {
                try {
                    int n = 0;
                    while ((n = bufferedInputStream.read(byArray)) > 0) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    bufferedOutputStream.flush();
                }
                catch (IOException iOException) {
                    throw new CvsException(iOException.getMessage());
                }
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    bufferedOutputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                bufferedOutputStream.close();
            }
            catch (Exception exception) {}
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsStatus(CvsDirectory cvsDirectory, String string, StatusHandler statusHandler) throws CvsException {
        String[] stringArray = new String[]{"status", string};
        String[] stringArray2 = this.getCommand(cvsDirectory, null, stringArray);
        try {
            Process process = this.runCvsProcess(stringArray2);
            this.parseStatusOutput(process.getInputStream(), statusHandler);
            this.waitForCompletion(process, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsUpdate(CvsDirectory cvsDirectory, UpdateHandler updateHandler) throws CvsException {
        String[] stringArray = new String[]{"update", "-l"};
        String[] stringArray2 = this.getCommand(cvsDirectory, null, stringArray);
        try {
            Process process = this.runCvsProcess(stringArray2);
            this.parseUpdateOutput(process.getInputStream(), updateHandler);
            this.waitForCompletion(process, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CvsException(exception.getMessage());
        }
    }

    void cvsUpdate(CvsDirectory cvsDirectory, String[] stringArray, UpdateHandler updateHandler) throws CvsException {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "update";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        String[] stringArray3 = this.getCommand(cvsDirectory, null, stringArray2);
        try {
            Process process = this.runCvsProcess(stringArray3);
            this.parseUpdateOutput(process.getInputStream(), updateHandler);
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    void cvsUpdateDirectory(CvsDirectory cvsDirectory, File file, UpdateHandler updateHandler) throws CvsException {
        String[] stringArray = new String[]{"update", "-l", "-d", file.getName()};
        String[] stringArray2 = this.getCommand(cvsDirectory, null, stringArray);
        try {
            Process process = this.runCvsProcess(stringArray2);
            this.parseUpdateOutput(process.getInputStream(), updateHandler);
            this.waitForCompletion(process, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CvsException(iOException.getMessage());
        }
    }

    protected void error(String string, String string2) throws CvsException {
        String string3 = String.valueOf(this.getClass().getName()) + "[" + string + "]: " + string2;
        System.err.println(string3);
        throw new CvsException(string3);
    }

    protected String[] getCommand(CvsDirectory cvsDirectory, String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = cvsDirectory.getCvsWrapper();
        String[] stringArray4 = cvsDirectory.getCvsDefaults();
        String[] stringArray5 = new String[stringArray3.length + stringArray4.length + (stringArray != null ? stringArray.length : 0) + (stringArray2 != null ? stringArray2.length : 0)];
        int n2 = 0;
        if (stringArray3 != null) {
            n = 0;
            while (n < stringArray3.length) {
                stringArray5[n2++] = stringArray3[n];
                ++n;
            }
        }
        if (stringArray4 != null) {
            n = 0;
            while (n < stringArray4.length) {
                stringArray5[n2++] = stringArray4[n];
                ++n;
            }
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                stringArray5[n2++] = stringArray[n];
                ++n;
            }
        }
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                stringArray5[n2++] = stringArray2[n];
                ++n;
            }
        }
        return stringArray5;
    }

    protected String getQuotedFilename(String string) {
        int n = string.indexOf(39);
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while ((c = string.charAt(n++)) != '\'') {
                stringBuffer.append(c);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return stringBuffer.toString();
    }

    File getTemporaryFile(String string) throws CvsException {
        String string2 = "cvs-" + System.currentTimeMillis() + "-" + string.length();
        File file = new File(tmpdir, string2);
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.print(string);
            printStream.close();
            return file;
        }
        catch (IOException iOException) {
            this.error("temporaryFile", "unable to create/use temporary file: " + file.getAbsolutePath());
            return file;
        }
    }

    private void parseCommitOutput(InputStream inputStream, CommitHandler commitHandler) throws IOException, CvsException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        while ((string = dataInputStream.readLine()) != null) {
            if (!string.startsWith("Checking in ")) continue;
            String string2 = string.substring("Checking in ".length(), string.length() - 1);
            commitHandler.notifyEntry(string2, 1);
        }
    }

    private void parseStatusOutput(InputStream inputStream, StatusHandler statusHandler) throws IOException, CvsException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() <= 0) continue;
            if (string.startsWith("==")) {
                string2 = null;
                string3 = null;
                continue;
            }
            stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    string4 = stringTokenizer.nextToken();
                    if (string4.equals("File:")) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals("no") && stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()).equals("file") && stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                        }
                    } else if (string4.equals("Repository") && stringTokenizer.nextToken().equals("revision:")) {
                        string3 = stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                    string2 = null;
                    string3 = null;
                }
            }
            if (string2 == null || string3 == null) continue;
            statusHandler.notifyEntry(string2, string3);
            string2 = null;
            string3 = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseUpdateOutput(InputStream var1_1, UpdateHandler var2_2) throws IOException, CvsException {
        var3_3 = new DataInputStream(var1_1);
        var4_4 = null;
        while ((var4_4 = var3_3.readLine()) != null) {
            if (var4_4.length() <= 0) continue;
            var5_5 = -1;
            var6_6 = var4_4.charAt(0);
            if (var4_4.charAt(1) != ' ') continue;
            switch (var6_6) {
                case 'U': {
                    var5_5 = 1;
                    ** GOTO lbl26
                }
                case 'A': {
                    var5_5 = 2;
                    ** GOTO lbl26
                }
                case 'R': {
                    var5_5 = 3;
                    ** GOTO lbl26
                }
                case 'M': {
                    var5_5 = 4;
                    ** GOTO lbl26
                }
                case 'C': {
                    var5_5 = 5;
                    ** GOTO lbl26
                }
                case '?': {
                    var5_5 = 7;
lbl26:
                    // 6 sources

                    var2_2.notifyEntry(var4_4.substring(2), var5_5);
                }
            }
        }
    }

    protected StringBuffer readError(InputStream inputStream, StringBuffer stringBuffer) throws IOException, CvsException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        while ((string = dataInputStream.readLine()) != null) {
            if (stringBuffer != null) {
                stringBuffer.append(String.valueOf(string) + "\n");
            }
            if (string.startsWith("cvs commit:")) {
                if ((string = string.substring(12)).startsWith("Up-to-date check failed")) {
                    String string2 = this.getQuotedFilename(string);
                    throw new UpToDateCheckFailedException(string2);
                }
                throw new CvsCommitException(string);
            }
            if (string.startsWith("cvs add:")) {
                throw new CvsAddException(string.substring(8));
            }
            if (!string.startsWith("cvs update:")) continue;
            throw new CvsUpdateException(string.substring(11));
        }
        return stringBuffer;
    }

    private StringBuffer readText(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        while ((string = dataInputStream.readLine()) != null) {
            if (stringBuffer == null) continue;
            stringBuffer.append(String.valueOf(string) + "\n");
        }
        return stringBuffer;
    }

    protected Process runCvsProcess(String[] stringArray) throws IOException {
        if (debug) {
            int n = 0;
            while (n < stringArray.length) {
                System.out.print(String.valueOf(stringArray[n]) + " ");
                ++n;
            }
            System.out.println();
        }
        return Runtime.getRuntime().exec(stringArray);
    }

    protected Process runCvsProcess(String[] stringArray, String[] stringArray2) throws IOException {
        if (debug) {
            int n = 0;
            while (n < stringArray.length) {
                System.out.print(String.valueOf(stringArray[n]) + " ");
                ++n;
            }
            System.out.println();
        }
        return Runtime.getRuntime().exec(stringArray, stringArray2);
    }

    protected synchronized void waitForCompletion(Process process, boolean bl) throws CvsException {
        while (true) {
            try {
                String string;
                CvsException cvsException = null;
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    try {
                        stringBuffer = this.readError(process.getErrorStream(), stringBuffer);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (CvsException cvsException2) {
                        cvsException = cvsException2;
                    }
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        process.getInputStream().close();
                    }
                    catch (Exception exception) {}
                    try {
                        process.getOutputStream().close();
                    }
                    catch (Exception exception) {}
                    try {
                        process.getErrorStream().close();
                    }
                    catch (Exception exception) {}
                    process.waitFor();
                    throw throwable;
                }
                try {
                    process.getInputStream().close();
                }
                catch (Exception exception) {}
                try {
                    process.getOutputStream().close();
                }
                catch (Exception exception) {}
                try {
                    process.getErrorStream().close();
                }
                catch (Exception exception) {}
                process.waitFor();
                int n = process.exitValue();
                if (n != 0) {
                    string = "Process exited with error code: " + n + " error [" + stringBuffer + "]";
                    if (debug) {
                        System.err.println(string);
                    }
                    if (bl) {
                        if (cvsException == null) {
                            throw new CvsException(string);
                        }
                        throw cvsException;
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

