// JDKCompiler.java
// $Id: JDKCompiler.java,v 1.2 1998/09/02 14:35:58 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1998.
// Please first read the full copyright statement in file COPYRIGHT.html
 
package org.w3c.jigsaw.pagecompile;

import java.io.*;
import sun.tools.javac.*;

/**
 * @version $Revision: 1.2 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class JDKCompiler implements PageCompiler {
    
    /**
     * compile some files.
     * @param args The compiler arguments (files+options)
     * @param out The outputStream, the compiler will write its output
     * in it.
     */
    public void compile(String args[], OutputStream out) {
	if (out == null)
	    out = System.out;
	(new Main(out, "compiler")).compile(args);
    }

    //testing only
    public static void main(String args[]) {
	System.out.println("toto");
	(new JDKCompiler()).compile(args, null);
	System.out.println("titi");
    }

}
