// MessagePopup.java
// $Id: MessagePopup.java,v 1.4 1998/01/22 13:10:55 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.widgets ;

import java.awt.*;
import java.awt.event.*;

/**
 * A very simple popup displaying a message.
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */

public class MessagePopup implements ActionListener {

  Frame frame    = null;
  Label msg      = null;
  Button okB     = null;

  public void actionPerformed(ActionEvent evt) {
    if (evt.getSource() == okB)
      frame.dispose();
  }


  /**
   * show the popup.
   */
  public void show() {
    frame.show();
  }

  /**
   * build a Message popup.
   * @param message, The message to display
   */
  public MessagePopup(String message) {
    this("",message);
  }
  
  /**
   * build a Message popup.
   * @param title, the title.
   * @param message, The message to display
   */
  public MessagePopup(String title, String message) {
    msg   = new Label(message);
    okB   = new Button("Ok");
    okB.addActionListener(this);
    frame = new Frame(title);
    frame.setLayout( new BorderLayout());
    frame.add(msg,"North");
    Panel p = new Panel();
    p.add(okB);
    frame.add(p,"South");
    frame.pack();
  }

}
