// ListEditor.java
// $Id: ListEditor.java,v 1.3 1998/01/22 13:10:45 bmahe Exp $
// Author: bmahe@sophia.inria.fr
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.widgets;

import java.awt.*;
import java.awt.event.*;
import java.math.*;

/**
 * ListEditor :
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */

public abstract class ListEditor extends Panel implements ActionListener {

  protected List   list       = null;
  protected Button editButton = null;
  
  protected abstract void edit();

    /**
   * ActionListsner implementation - One of our button was fired.
   * @param evt The ActionEvent.
   */

  public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand();
    if ( command.equals("edit" ) )
      edit();
  }

  public ListEditor() {
    this(5,false);
  }

  public ListEditor(int nbVisible, boolean multiple) {

    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    setLayout( layout );
    
    Panel control = new Panel();
    editButton = new Button ("Edit");
    editButton.setActionCommand("edit");
    editButton.addActionListener(this);
    control.add( editButton , "Center");
    Panel plist = new Panel();

    list = new List(nbVisible, multiple);
    plist.add(list);

    c.fill = GridBagConstraints.BOTH;

    c.gridwidth = GridBagConstraints.RELATIVE;
    layout.setConstraints(plist, c);
    add(plist);

    c.gridwidth = GridBagConstraints.REMAINDER;
    layout.setConstraints(control, c);
    add(control);
  }

}
