// FrameEventListener.java
// $Id: FrameEventListener.java,v 1.1 1998/01/22 12:59:43 bmahe Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.resources.event;

import org.w3c.tools.resources.*;

public interface FrameEventListener extends java.util.EventListener {
    
  /**
   * This handles the <code>FRAME_ADDED</code> kind of events.
   * @param evt The FrameEvent.
   */

  public void frameAdded(FrameEvent evt);

  /**
   * This handles the <code>FRAME_MODIFIED</code> kind of events.
   * @param evt The event describing the change.
   */

  public void frameModified(FrameEvent evt);

  /**
   * A frame is about to be removed
   * This handles the <code>FRAME_REMOVED</code> kind of events.
   * @param evt The event describing the change.
   */

  public void frameRemoved(FrameEvent evt);
     
}
