// ZipFrame.java
// $Id: ZipFrame.java,v 1.4 1998/04/14 13:50:23 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1998.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.zip;

import java.util.zip.*;
import java.util.*;
import java.io.*;

import org.w3c.util.*;
import org.w3c.tools.resources.*;
import org.w3c.jigsaw.frames.*;
import org.w3c.jigsaw.http.* ;
import org.w3c.jigsaw.html.* ;
import org.w3c.www.mime.*;
import org.w3c.www.http.*;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.NotAProtocolException;

/**
 * @version $Revision: 1.4 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class ZipFrame extends HTTPFrame {
    
    protected ZipFileResource zipfresource = null;

    public void registerResource(FramedResource resource) {
	super.registerResource(resource);
	if (resource instanceof ZipFileResource)
	    zipfresource = (ZipFileResource) resource;
    }

    /**
     * Create the reply relative to the given file.
     * @param request the incomming request.
     * @return A Reply instance
     */
    protected Reply createFileReply(Request request) 
	throws ProtocolException, NotAProtocolException
    {
	Reply reply = null;
	if (zipfresource == null) {
	    throw new NotAProtocolException("this frame is not attached to a "+
					    "ZipFileResource. ("+
					    resource.getIdentifier()+")");
	}
	// Default to full reply:
	reply = createDefaultReply(request, HTTP.OK) ;
	InputStream in = zipfresource.getInputStream();
	if (in != null)
	    reply.setStream(in);
	return reply ;
    }

    /**
     * The default PUT method replies with a not implemented.
     * @param request The request to handle.
     * @exception ProtocolException Always thrown, to return a NOT_IMPLEMENTED
     *    error.
     * @exception NotAProtocolException If the client instance controling the
     * request processing got a fatal error.
     */

    public Reply put(Request request)
	throws ProtocolException, NotAProtocolException
    {
	Reply error = request.makeReply(HTTP.NOT_IMPLEMENTED) ;
	error.setContent("Method PUT not implemented for zipped document") ;
	throw new HTTPException (error) ;
    }
}
