// JigsawServletOutputStream.java
// $Id: JigsawServletOutputStream.java,v 1.6 1998/01/22 14:10:25 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.servlet;

import java.io.*;

import javax.servlet.*;

/**
 * This is certainly not a good implementation, it's enough though.
 * (more buffering, better buffering, although the Client output stream
 * will usually come with its own buffering.
 *  @author Alexandre Rafalovitch <alex@access.com.au>
 *  @author Anselm Baird-Smith <abaird@w3.org>
 */

class JigsawServletOutputStream extends ServletOutputStream {
    DataOutputStream out = null;
    JigsawHttpServletResponse resp = null;

    public void print(int i)
	throws IOException
    {
	out.writeBytes(Integer.toString(i));
    }

    public void print(long l)
	throws IOException
    {
	out.writeBytes(Long.toString(l));
    }

    public void print(String s) 
	throws IOException 
    {
	out.writeBytes(s);
    }

    public void println() 
	throws IOException
    {
	out.writeBytes("\r\n");
    }

    public void println(int i)
	throws IOException
    {
	print(i); println();
    }

    public void println(long l) 
	throws IOException
    {
	print(l); println();
    }

    public void println(String s)
	throws IOException
    {
	print(s); println();
    }

    public void write(int b) throws IOException {
	out.write(b);
    }

    public void write(byte b[]) throws IOException {
	out.write(b);
    }

    public void write(byte b[], int off, int len) throws IOException {
	out.write(b, off, len);
    }

    public void flush() throws IOException {
	out.flush();
    }

    public void close() throws IOException {
	out.close();
    }

    JigsawServletOutputStream(JigsawHttpServletResponse resp
			      , DataOutputStream out) {
	this.out  = out;
	this.resp = resp;
    }

}

