// ControlHelper.java
// $Id: ControlHelper.java,v 1.7 1998/02/11 10:20:09 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigadm.editors ;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import org.w3c.jigadm.*;
import org.w3c.jigsaw.admin.*;
import org.w3c.tools.resources.Attribute;

import org.w3c.tools.widgets.*;

public class ControlHelper extends ResourceHelper {

  class ControlListener implements ActionListener {

        public void actionPerformed(ActionEvent ae) {
	    if(ae.getSource() instanceof ImageButton) {
		executeAction(ae.getActionCommand());
	    }
	}
    }
    
    private RemoteResourceWrapper rrw = null;
    Panel widget;
    private boolean initialized = false;

    public void commitChanges() {
    }
	

    public boolean hasChanged() {
	return false;
    }

    public void resetChanges() {
    }

    public void clearChanged() {
    }

    public Component getComponent() {
	return widget;
    }

    public final String getTitle() {
	return "Control";
    }

//     public ControlHelper() {
//         widget = new BorderPanel(BorderPanel.RAISED,2);
// 	widget.setLayout(new GridLayout(4, 1, 1, 1));
// 	//widget = new Panel(new GridLayout(1, 4));
//     }

  public ControlHelper() {
    widget = new BorderPanel(BorderPanel.LOWERED,2);
    widget.setLayout(new BorderLayout());
  }

    protected void executeAction(String action) {
	try {
	    rrw.getResource().loadResource(action);
	} catch (Exception ex) {
	    errorPopup("Error",ex);
	}
    }

  public void initControlPanel() {
    ControlListener cl = new ControlListener();
    Panel tfp;
    Panel ControlPanel = new Panel(new BorderLayout());
    PropertyManager pm = PropertyManager.getPropertyManager();
	    
    ScrollPane fsp = new ScrollPane();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.insets = new Insets(5,0,0,0);
    Panel fspp = new Panel(gbl);
    fsp.add(fspp);
    Image checkpoint_im, save_im, stop_im, restart_im;
    ImageButton ib;
    Label l;
    gbc.fill = GridBagConstraints.HORIZONTAL;
    gbc.weightx = 0;
    gbc.weighty = 0;

    checkpoint_im = Toolkit.getDefaultToolkit().getImage(
				      pm.getIconLocation("checkpoint"));
    save_im       = Toolkit.getDefaultToolkit().getImage(
				      pm.getIconLocation("save"));
    stop_im       = Toolkit.getDefaultToolkit().getImage(
				      pm.getIconLocation("stop"));
    restart_im    = Toolkit.getDefaultToolkit().getImage(
				      pm.getIconLocation("restart"));

    // Checkpoint
    ib = new ImageButton(checkpoint_im, "Checkpoint");
    ib.addActionListener(cl);
    gbc.gridwidth = 1;
    gbl.setConstraints(ib, gbc);
    fspp.add(ib);    
    l = new Label("Checkpoint");
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbl.setConstraints(l, gbc);
    fspp.add(l);

    //Save
    ib = new ImageButton(save_im, "Save");
    ib.addActionListener(cl);
    gbc.gridwidth = 1;
    gbl.setConstraints(ib, gbc);
    fspp.add(ib);
		
    l = new Label("Save");
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbl.setConstraints(l, gbc);
    fspp.add(l);

    //Stop
    ib = new ImageButton(stop_im, "Stop");
    ib.addActionListener(cl);
    gbc.gridwidth = 1;
    gbl.setConstraints(ib, gbc);
    fspp.add(ib);
		
    l = new Label("Save & Stop");
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbl.setConstraints(l, gbc);
    fspp.add(l);

    //Restart
    ib = new ImageButton(restart_im, "Restart");
    ib.addActionListener(cl);
    gbc.gridwidth = 1;
    gbl.setConstraints(ib, gbc);
    fspp.add(ib);
		
    l = new Label("Restart");
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbl.setConstraints(l, gbc);
    fspp.add(l);

	    
    ControlPanel.add("Center", fspp);
    widget.add("Center", ControlPanel);
    widget.validate();
    widget.setVisible(true);
  }

  
    public void initialize(RemoteResourceWrapper rrw, Properties pr)
	throws RemoteAccessException
    {
	if(!initialized)
	    initialized = true;
	else
	    return;

// 	Button check   = new Button("Checkpoint");
// 	Button save    = new Button("Save");
// 	Button stop    = new Button("Stop");
// 	Button restart = new Button("Restart");
// 	ControlListener cl = new ControlListener();

 	this.rrw = rrw;
// 	check.addActionListener(cl);
// 	save.addActionListener(cl);
// 	stop.addActionListener(cl);
// 	restart.addActionListener(cl);
//  	widget.add(check);
//  	widget.add(save);
//  	widget.add(stop);
//  	widget.add(restart);
	initControlPanel();
    }
}

