// ResourceUpgrader.java
// $Id: ResourceUpgrader.java,v 1.7 1997/07/30 14:01:53 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.upgrade.from1to2;

import java.io.*;
import java.util.*;

class UpgraderData {
    String cls      = null;
    String upgrader = null;

    UpgraderData(String cls, String upgrader) {
	this.cls      = cls;
	this.upgrader = upgrader;
    }
}

public abstract class ResourceUpgrader {
    public static UpgraderData upgraders[] = null;

    static {
	// WARNING: order of declarations matter (all hacked allow here)
	upgraders = new UpgraderData[6];
	// The ForwardDirectory is now a filtered resource
	upgraders[0] = new UpgraderData(
            "w3c.jigsaw.proxy.ForwardDirectory"
	    , "w3c.jigsaw.upgrade.from1to2.IsFilterResource");
	// All filtered resources sub-classes need fix:
	upgraders[1] = new UpgraderData(
	    "w3c.jigsaw.resources.FilteredResource"
	    , "w3c.jigsaw.upgrade.from1to2.FilteredResourceUpgrader");
	// All other raw resources need fix (can't say Resource since move):
	upgraders[2] = new UpgraderData(
	    "w3c.jigsaw.resources.HTTPResource"
	    , "w3c.jigsaw.upgrade.from1to2.RawResourceUpgrader");
	upgraders[3] = new UpgraderData(
	    "w3c.jigsaw.auth.AuthUser"
	    , "w3c.jigsaw.upgrade.from1to2.RawResourceUpgrader");
	upgraders[4] = new UpgraderData(
	    "w3c.jigsaw.resources.ResourceFilter"
	    , "w3c.jigsaw.upgrade.from1to2.RawResourceUpgrader");
	upgraders[5] = new UpgraderData(
	    "w3c.jigsaw.auth.AuthRealm"
	    , "w3c.jigsaw.upgrade.from1to2.RawResourceUpgrader");
    }

    public static ResourceUpgrader getUpgrader(String clsname) 
	throws ResourceUpgraderException
    {
	try {
	    String upname  = null;
	    for (int i = 0 ; i < upgraders.length ; i++) {
		if (ClassLooker.isSubclass(clsname, upgraders[i].cls)) {
		    upname = upgraders[i].upgrader;
		    break;
		}
	    }
	    if (upname != null) {
		Class c = Class.forName(upname);
		return (ResourceUpgrader) c.newInstance();
	    } 
	} catch (ClassNotFoundException ex) {
	    throw new ResourceUpgraderException("unable to load class \""
						+ clsname
						+ "\"");
	} catch (Exception ex) {
	    throw new ResourceUpgraderException("unable to upgrade class \""
						+ clsname
						+ "\"");
	}
	return null;
    }

    public static ResourceUpgrader getUpgrader(Class cls) 
	throws ResourceUpgraderException
    {
	return getUpgrader(cls.getName());
    }

    public static ResourceUpgrader getUpgrader(byte oldbits[])
	throws ResourceUpgraderException
    {
	// Get the class name out of the bits:
	try {
	    DataInputStream in = (new DataInputStream
				  (new ByteArrayInputStream(oldbits)));
	    String clsname = in.readUTF();
	    return getUpgrader(clsname);
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
	return null;
    }

    abstract public byte[] upgrade(byte oldbits[], int off, int len);
    abstract public byte[] upgrade(Class cls, DataInputStream in);

}
