// IndexerModule.java
// $Id: IndexerModule.java,v 1.3 1997/07/30 14:00:11 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.indexer;

import w3c.jigsaw.resources.ResourceContext;

public class IndexerModule {
    public static final String  NAME    = "w3c.jigsaw.indexer";
    private static final String INDEXER = "w3c.jigsaw.indexer.name";

    protected IndexersCatalog catalog = null;

    public void registerIndexer(ResourceContext ctxt, String name) {
	ctxt.registerModule(INDEXER, name);
    }

    public ResourceIndexer getIndexer(ResourceContext ctxt) {
	String idxname = (String) ctxt.getModule(INDEXER);
	try {
	    return (ResourceIndexer) catalog.lookup(idxname);
	} catch (Exception ex) {
	    // FIXME !
	    ex.printStackTrace();
	}
	return null;
    }

    public ResourceIndexer getIndexer(String name) {
	try {
	    return (ResourceIndexer) catalog.lookup(name);
	} catch (Exception ex) {
	    return null;
	}
    }

    public IndexerModule(IndexersCatalog catalog) {
	this.catalog = catalog;
    }
}
