/*
 *  PropertySet.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: PropertySet.java,v 1.2 1998/01/22 14:33:37 bmahe Exp $
 */

package org.w3c.www.pics;

import java.util.Dictionary;
import java.util.Hashtable;

public class PropertySet extends Hashtable {

  private Dictionary defaults;

  public PropertySet(Dictionary defaults)
  {
    super();
    this.defaults = defaults;
  }

  public Object putWithMap(Object key, Object value, Dictionary mappers)
    throws PICSParserException
  {
    // System.out.println("put: " + key + " " + value);
    Mapper mapper;
    if (mappers != null && (mapper = (Mapper)mappers.get(key)) != null)
      return put(key, mapper.map(value));
    else
      return put(key, value);
  }

  public Object get(Object key)
  {
    Object value = super.get(key);
    if (value != null)
      return value;
    else if (defaults != null)
      return defaults.get(key);
    else
      return null;
  }

}
