/*
 *  PICSLabel.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: PICSLabel.java,v 1.2 1998/01/22 14:33:25 bmahe Exp $
 */

package org.w3c.www.pics;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Date;
import java.util.Vector;
import java.net.URL;
import org.w3c.tools.sexpr.Symbol;

public class PICSLabel {

  private Symbol version;
  private URL service;
  private Dictionary options;
  private Dictionary ratings;

  public PICSLabel(Symbol version, URL service, Dictionary options)
  {
    this.version = version;
    this.service = service;
    this.options = options;
    this.ratings = new Hashtable();
  }

  public Symbol getVersion()
  {
    return version;
  }

  public URL getService()
  {
    return service;
  }

  public Object getOption(Symbol name)
  {
    return options.get(name);
  }

  public Dictionary getOptions()
  {
    return options;
  }

  protected Object setOption(Symbol name, Object option)
  {
    return options.put(name, option);
  }

  public Dictionary getRatings()
  {
    return ratings;
  }

  public RatingValue getRating(String transmitName)
  {
    return (RatingValue)ratings.get(transmitName);
  }

  public protected RatingValue setRating(String transmitName,
                                         RatingValue rating)
  {
    ratings.put(transmitName, rating);
    return rating;
  }

  public void addRatings(Vector data)
    throws PICSParserException
  {
    for (int i = 0; i < data.size(); i += 2) {
      Object values = data.elementAt(i + 1);
      RatingValue rating;
      if (values instanceof Number)      // single number
        rating = new RatingValue(((Number)values).doubleValue());
      else if (values instanceof Vector) // list of numbers
        rating = new RatingValue((Vector)values);
      else                               // none of the above
        throw new PICSParserException("Ill-structured ratings");
      setRating(((Symbol)data.elementAt(i)).toString(), rating);
    }
  }

}
