// httpd.java
// $Id: httpd.java,v 1.1 1997/11/21 00:49:10 veillard Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.httpng;

import java.io.* ;
import java.util.*;
import java.net.*;

import javastubs.iluhttp.*;

import w3c.jigsaw.http.*;
// import w3c.www.httpng.*;

/**
 * <p>The http-ng server main class. It extends the existing httpd
 *    classes but get its connexions from HTTP-NG interfaces instead
 *    of a socket.
 */

public class httpd extends w3c.jigsaw.http.httpd
{
    static xerox.ilu.IluServer server = null;
    static xerox.ilu.IluClassRep iluClass;
    static String serverId = "httpng-server";
    static String ih = "server root";

    HttpNgClientFactory ngFactory;

    /**
     * The main thread of an HTTP-NG process
     */
    public void run () {
	// Emit some traces before starting up:
	System.out.println(getBanner()+": serving at "+getURL());
	System.out.flush() ;
	errlog("started at: "+new Date()+".");

	// 
	System.out.println("< Server start...");
	iluClass = ResourceStub.iluClass();
	System.out.println("< iluClass built");
	System.out.println("< server init");
	server = xerox.ilu.IluServer.createServer(serverId);
	System.out.println("< server created");
	System.out.println("< port created");
	ngFactory = new HttpNgClientFactory(this);
	System.out.println("< factory created");
	javastubs.iluhttp.ResourceStub.registerTrueObject(ih, ngFactory, server);
	System.out.println("< factory registered: sbh: " +
	          xerox.ilu.Ilu.sbhOfObject(ngFactory));
        xerox.ilu.IluSimpleBinding.publish(ngFactory);
	System.out.println("< sleep and serve requests");
    }

}

