// HttpNgRequest.java
// $Id: HttpNgRequest.java,v 1.1 1997/11/21 00:49:09 veillard Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.httpng;

import java.io.*;
import java.net.*;

import w3c.www.http.*;
import w3c.www.mime.*;
import javastubs.iluhttp.*;
import w3c.jigsaw.http.*;

/**
 * The HttpNgRequest class extends the standard Request class
 * used by Jigsaw to accomodate the handling of HTTP-NG requests.
 * Access to the various headers fields as well as the body
 * message stream is quite different than for request generated
 * by an HTTP Java protocol. However the processing of the Request
 * should be the same.
 */

public class HttpNgRequest extends w3c.jigsaw.http.Request {
    private javastubs.iluhttp.Request ngRequest = null;
    static Client baseclient = null;
    static MimeParser baseparser = null;

    public HttpNgRequest() {
        super (baseclient, baseparser);
    }

    /**
     * A constructor, initializing the HttpNgRequest
     * @param ngReq the incoming HTTP-NG request
     * @return a properly initialized HttpNgRequest
     */
    public static HttpNgRequest create(httpd server,
                   javastubs.iluhttp.Request ngReq) {
	HttpNgRequest req = new HttpNgRequest();

	// System.out.println("HttpNgRequest.create()");
        req.ngRequest = ngReq;
	for (int i = 0;i < ngReq.headers.length;i++) {
	    //req.setHeaderValue(ngReq.headers[i].name,
	    //		       new HttpNgHeaderValue(ngReq.headers[i].value));
	    req.setValue(ngReq.headers[i].name, ngReq.headers[i].value);
	}
	req.setURLPath(server.getURL() + ngReq.URI);
	return(req);
    }

    /**
     * Get this reply entity body.
     * The reply entity body is returned as an InputStream, that the caller
     * has to read to actually get the bytes of the content.
     * @return An InputStream instance. If the reply has no body, the returned
     * input stream will just return <strong>-1</strong> on first read.
     */

    public InputStream getInputStream()
	throws IOException
    {
	System.out.println("HttpNgRequest.getInputStream()");
        return(new ByteArrayInputStream(ngRequest.body));
    }

    /*
    public HttpNgRequest (Client client, MimeParser parser) {
	super (client, parser);
    }
     */
}


