// RealmsCatalog.java
// $Id: RealmsCatalog.java,v 1.9 1998/01/23 10:08:48 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.auth;

import java.util.*;
import java.io.*;

import org.w3c.tools.resources.*;
import org.w3c.jigsaw.http.*;

public class RealmsCatalog extends ExternalContainer {

  /**
   * Load the given realm and return the AuthRealm instance.
   * @param name The realm identifier.
   */

  public synchronized ResourceReference loadRealm(String name) {
    return lookup(name);
  }

  /**
   * Enumerate the list of available realms.
   */

  public synchronized Enumeration enumerateRealmNames() {
    return enumerateResourceIdentifiers() ;
  }

  /**
   * register the given new realm.
   * @param realm The new realm to register.
   */

  public synchronized void registerRealm(AuthRealm realm) {
    addResource(realm, null) ;
  }
   
  public void registerResource(String name,
			       Resource resource,
			       Hashtable defs) 
  {
    System.out.println("regiter realm : "+name);
    if( resource instanceof AuthRealm) {
      String repname;
      repname = name + ".db";
      File file = new File(getServer().getAuthDirectory(), repname);
      if ( file.exists() ) {
	// fancy exception FIXME
	return;
      }
      registerRealm(AuthRealm.makeRealm( new ResourceContext(getContext()),
					 name,
					 file));
    }
  }
    
  /**
   * Unregister the given realm from the catalog.
   * @param name The name of the catalog.
   */

  public synchronized void unregisterRealm(String name) 
    throws MultipleLockException
  {
    delete(name);
  }

  /**
   * Save the catalog back to disk.
   */

  public synchronized void save() {

  }

  public RealmsCatalog(ResourceContext context) {
    super("realms",
	  new File(context.getServer().getAuthDirectory(), "realms.db"),
	  context,
	  true);
  }

  public RealmsCatalog(ResourceContext context, String rep) {
    super("realms",
	  new File(context.getServer().getAuthDirectory(), 
		   ((rep.endsWith(".db")) ? rep : rep + ".db")),
	  context,
	  true);
  }
}
