// ControlHelper.java
// $Id: ControlHelper.java,v 1.6 1998/01/22 13:23:57 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigadm.editors ;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import org.w3c.jigadm.*;
import org.w3c.jigsaw.admin.*;
import org.w3c.tools.resources.Attribute;

public class ControlHelper extends ResourceHelper {

    private class ControlListener implements ActionListener {

        public void actionPerformed(ActionEvent ae) {
	    if(ae.getSource() instanceof Button) {
		executeAction(ae.getActionCommand());
	    }
	}
    }
    
    private RemoteResourceWrapper rrw = null;
    Panel widget;
    private boolean initialized = false;

    public void commitChanges() {
    }
	

    public boolean hasChanged() {
	return false;
    }

    public void resetChanges() {
    }

    public void clearChanged() {
    }

    public Component getComponent() {
	return widget;
    }

    public final String getTitle() {
	return "Control";
    }

    public ControlHelper() {
	widget = new Panel(new GridLayout(1, 4));
    }

    protected void executeAction(String action) {
	try {
	    rrw.getResource().loadResource(action);
	} catch (Exception ex) {
	    errorPopup("Error",ex);
	}
    }

    public void initialize(RemoteResourceWrapper rrw, Properties pr)
	throws RemoteAccessException
    {
	if(!initialized)
	    initialized = true;
	else
	    return;

	Button check   = new Button("Checkpoint");
	Button save    = new Button("Save");
	Button stop    = new Button("Stop");
	Button restart = new Button("Restart");
	ControlListener cl = new ControlListener();

	this.rrw = rrw;
	check.addActionListener(cl);
	save.addActionListener(cl);
	stop.addActionListener(cl);
	restart.addActionListener(cl);
	widget.add(check);
	widget.add(save);
	widget.add(stop);
	widget.add(restart);
    }
}
