// ServletMapperFrame.java
// $Id: ServletMapperFrame.java,v 1.2.4.6 2000/04/21 08:09:04 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.servlet;

import java.util.*;
import java.io.* ;
import java.net.*;

import org.w3c.tools.resources.*;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.frames.*;
import org.w3c.www.http.*;

import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;

/**
 * Perform an internal redirect.
 */
public class ServletMapperFrame extends HTTPFrame {
    /**
     * Attributes index - The index for the target attribute.
     */
    protected static int ATTR_TARGET = -1 ;

    static {
	Attribute a   = null ;
	Class     cls = null ;
	// Get a pointer to our class:
	try {
	    cls = Class.forName("org.w3c.jigsaw.servlet.ServletMapperFrame") ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	a = new StringAttribute("servlet-url"
				, null
				, Attribute.EDITABLE);
	ATTR_TARGET = AttributeRegistry.registerAttribute(cls, a) ;
    }

    protected String getTarget() {
	return (String) getValue(ATTR_TARGET, null);
    }

    /**
     * Gets, from the first line of the HTTP request, 
     * the part of this request's URI that is to the left of any query string.
     */
    public  String getRequestURI(Request request)
    {
	String uri = null;
	//fixme test
	if (request.isProxy()) {
	    uri = request.getURL().toExternalForm();
	} else {
	    uri = request.getURLPath();
	}
	if (request.hasQueryString()) {
	    String query = request.getQueryString();
	    int idx = uri.lastIndexOf(query);
	    if (idx != -1) {
		uri = uri.substring(0, idx-1);
	    }
	}
	return uri;
    }

    /**
     * Perform the request.
     * @param req The request to handle.
     * @exception ProtocolException If request couldn't be processed.
     * @exception ResourceException If the resource got a fatal error.
     */
    public ReplyInterface perform(RequestInterface req) 
	throws ProtocolException, ResourceException
    {
	Reply        reply  = (Reply) performFrames(req);
	if (reply != null) 
	    return reply;
	Request request = (Request) req;
	httpd    server = (httpd) getServer();
	String     host = request.getHost();
	request.setState(JigsawRequestDispatcher.REQUEST_URI_P, 
			 getRequestURI(request));
	request.setState(JigsawRequestDispatcher.QUERY_STRING_P, 
			 request.getQueryString());
	request.setState(JigsawRequestDispatcher.SERVLET_PATH_P, getURLPath());
	try {
	    String target = null;
	    if (request.hasQueryString())
		target = getTarget()+"?"+request.getQueryString();
	    else
		target = getTarget();

	    if (host == null)
		request.setURL(new URL(server.getURL(), target));
	    else 
		request.setURL(new URL(server.getURL().getProtocol(),
				       host, target));
	    request.setInternal(true);
	} catch (MalformedURLException ex) {
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR);
	    error.setContent("<html><head><title>Server Error</title>"+
			     "</head><body><h1>Server misconfigured</h1>"+
			     "<p>The resource <b>"+getIdentifier()+"</b>"+
			     "has an invalid target attribute : <p><b>"+
			     getTarget()+"</b></body></html>");      
	    throw new HTTPException (error);
	}
	return server.perform(request);
    }
}
