// UnixProp.java
// $Id: UnixProp.java,v 1.5 1998/01/22 14:03:36 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.http;

import java.io.* ;
import java.util.* ;

import org.w3c.tools.resources.*;
import org.w3c.www.http.*;
//import org.w3c.jigsaw.forms.* ;
import org.w3c.jigsaw.daemon.*;
import org.w3c.jigsaw.config.*;

/**
 * A wrapper class to give access to editable properties through a resource.
 * This class wraps UNIX specific properties.
 */

class UnixProp extends PropertySet {
    private static String title = "Unix properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("org.w3c.jigsaw.http.UnixProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Group
	a = new StringAttribute(httpd.SERVER_GROUP_P
				, null
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// User
	a = new IntegerAttribute(httpd.SERVER_USER_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    UnixProp(String name, httpd server) {
	super(name, server);
    }
}

