// ExtendedCommonLogger.java
// $Id: ExtendedCommonLogger.java,v 1.3.4.2 2000/06/29 08:18:28 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.http ;

import java.io.* ;
import java.util.Date ;

import org.w3c.jigsaw.daemon.*;
import org.w3c.jigsaw.auth.AuthFilter;
import org.w3c.util.*;

/**
 * The ExtendedCommonLogger class implements the abstract Logger class.
 * It just rotates the log every month and use the extended log format
 * @see org.w3c.jigsaw.http.CommonLogger
 */


public class ExtendedCommonLogger extends CommonLogger {

    private   byte                 msgbuf[] = null ;

    /**
     * Log the given HTTP transaction.
     * This is shamelessly slow.
     */

    public void log (Request request, Reply reply, int nbytes, long duration) {
	Client client = request.getClient() ;
	String entry  = null ;
	long   date   = reply.getDate();
	// Compute the time zone offset, first call only.
	if ( tz == -1 ) {
	    tz = new Date().getTimezoneOffset();
	}
	Date   now;
	if (date < 0 ) {
	    now = new Date((new Date()).getTime() + tz*60*1000);
	} else {
	    now = new Date(date + (tz*60*1000));
	}

	if (rotateLevel > 0) {
	    checkLogFile(now);
	}

	String user = (String) request.getState(AuthFilter.STATE_AUTHUSER);

	entry = client.getInetAddress().getHostAddress()
	    + " " + "-"			  	   // user name
	    + " " + ((user == null ) ? "-" : user) // auth user name
	    + ((now.getDate() < 10) ? " [0" : " [")
	    + (now.getDate() 		   	   // current date
	       + "/" + monthnames[now.getMonth()]
	       + "/" + (now.getYear() + 1900)
	       + ((now.getHours() < 10)
		  ? (":0" + now.getHours())
		  : (":" + now.getHours()))
	       + ((now.getMinutes() < 10)
		  ? (":0" + now.getMinutes())
		  : (":" + now.getMinutes()))
	       + ((now.getSeconds() < 10)
		  ? (":0" + now.getSeconds())
		  : (":" + now.getSeconds()))
	       + " +0]")
	    + " \"" + request.getMethod()	// request line
	    + " " + request.getURL()
	    + " " + request.getVersion()
	    + "\" " + reply.getStatus()		// reply status
	    + " " + nbytes			// # of emited bytes
	    + " \"" + 
	    ((request.getReferer() == null) ? "-" : request.getReferer())
	    + "\"" // the referer (ext log)
	    + " \"" + 
	    ((request.getUserAgent() == null) ? "-" : request.getUserAgent())
	    + "\"" // User agent
	    + "\n" ;
	logmsg (entry) ;
    }
    
    /**
     * Construct a new Logger instance.
     */
     
    ExtendedCommonLogger () {
	this.msgbuf = new byte[128] ;
    }   
    
}
