// IO.java
// $Id: IO.java,v 1.2 1999/09/02 14:04:17 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1998.
// Please first read the full copyright statement in file COPYRIGHT.html
 
package org.w3c.util;

import java.io.*;

/**
 * @version $Revision: 1.2 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class IO {

    /**
     * Copy source into dest.
     */
    public static void copy(File source, File dest) 
	throws IOException
    {
	BufferedInputStream in = 
	    new BufferedInputStream( new FileInputStream(source) );
	BufferedOutputStream out =
	    new BufferedOutputStream( new FileOutputStream(dest) );
	byte buffer[] = new byte[1024];
	int read = -1;
	while ((read = in.read(buffer, 0, 1024)) != -1)
	    out.write(buffer, 0, read);
	out.flush();
	out.close();
	in.close();
    }

    /**
     * Copy source into dest.
     */
    public static void copy(InputStream in, OutputStream out) 
	throws IOException
    {
	BufferedInputStream bin = 
	    new BufferedInputStream(in);
	BufferedOutputStream bout =
	    new BufferedOutputStream(out);
	byte buffer[] = new byte[1024];
	int read = -1;
	while ((read = bin.read(buffer, 0, 1024)) != -1)
	    bout.write(buffer, 0, read);
	bout.flush();
	bout.close();
	bin.close();
    } 
    
}
