// JpegCommentHandler.java
// $Id: JpegCommentHandler.java,v 1.1.2.3 1999/09/30 08:33:28 ylafon Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.jpeg;

import java.io.*;
import java.util.Vector;


public class JpegCommentHandler {
    
    protected File jpegfile;
    protected InputStream  in;

    /**
     * Get this image reader
     */
    public Reader getReader() {
	JpegHeaders jpeghead = new JpegHeaders(in);
	StringBuffer sb = new StringBuffer();
	// get the comments out of the jpeg file
	String comms[] = jpeghead.getComments();
	// and dump them in one big string
	for (int i=0; i< comms.length; i++) {
	    sb.append(comms[i]);
	}
	return new StringReader(sb.toString());
    }

    /**
     * Get this image writer
     */
    public Writer getOutputStreamWriter(OutputStream out, String enc) 
	throws UnsupportedEncodingException
    {
	return new JpegCommentWriter(out, in, enc);
    }

    /**
     * Get this image writer
     */
    public Writer getOutputStreamWriter(OutputStream out) {
	return new JpegCommentWriter(out, in);
    }

    /**
     * create it out of a File
     */
    public JpegCommentHandler(File jpegfile) 
	throws FileNotFoundException
    {
	this.in = 
	    new BufferedInputStream( new FileInputStream(jpegfile));
	this.jpegfile = jpegfile;
    }

    /**
     * create it from an input stream
     */
    public JpegCommentHandler(InputStream in) {
	this.in = in;
    }
}
    
