// ProxyProp.java
// $Id: ProxyProp.java,v 1.13 1998/09/11 08:39:31 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.proxy;

import java.util.Enumeration;
import java.io.*;

import org.w3c.tools.resources.*;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.resources.*;
import org.w3c.jigsaw.config.*;
import org.w3c.util.*;

import org.w3c.www.protocol.http.micp.*;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.cache.CacheFilter;

class ProxyProp extends PropertySet {
    private static String title = "Proxy properties";

    private static String MICP_PROP_NAME       = "micp";
    private static String CACHE_PROP_NAME      = "cache";
    private static String PROXY_DISP_PROP_NAME = "dispatcher";

    protected static int ATTR_FILTERS = -1;

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("org.w3c.jigsaw.proxy.ProxyProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Register the maximum number of allowed connections:
	a = new IntegerAttribute(HttpManager.CONN_MAX_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the timeout on the client socket
	a = new IntegerAttribute(HttpManager.TIMEOUT_P
				 , new Integer(300000) // default 5mn
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
        // Register the proxy set property
	a = new BooleanAttribute(HttpManager.PROXY_SET_P
				, null
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the proxy host:
	a = new StringAttribute(HttpManager.PROXY_HOST_P
				, null
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the proxy port:
	a = new IntegerAttribute(HttpManager.PROXY_PORT_P
				 , new Integer(80)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the filters property
	a = new StringArrayAttribute(HttpManager.FILTERS_PROP_P
				     , null
				     , Attribute.EDITABLE);
	ATTR_FILTERS = AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    /**
     * Set value forwards the effectation to the properties.
     * @param idx The attribute (property in that case) being set.
     * @param value The new value for that property.
     */

    protected String[] getFilters() {
	return (String[]) getValue(ATTR_FILTERS, null);
    }

    protected void initializeFiltersProps() {
	String flt[] = getFilters();
	if (flt == null)
	    return;
	// FIXME! shouldget the name of the property set associated
	// to the filter, and verify if it is present or not
	// if not, register the property set
	PropertySet p = null;
	for(int i=0; i<flt.length; i++) {
	    if(flt[i].equals("org.w3c.www.protocol.http.micp.MICPFilter")){
		if (server.getPropertySet(MICP_PROP_NAME) == null) {
		    p = new MICPProp(MICP_PROP_NAME, server);
		    server.registerPropertySet(p);
		}
	    } else if (flt[i].equals(
		       "org.w3c.www.protocol.http.cache.CacheFilter")) {
		if (server.getPropertySet(CACHE_PROP_NAME) == null) {
		    p = new CacheProp(CACHE_PROP_NAME, server);
		    server.registerPropertySet(p);
		    ObservableProperties props = server.getProperties();
		    File c = 
			props.getFile(CacheFilter.CACHE_DIRECTORY_P, null);
		    if ( c == null ) {
			c = new File(server.getConfigDirectory(), 
				     "cache");
			props.putValue(CacheFilter.CACHE_DIRECTORY_P,
				       c.toString());
		    }
		}
	    } else if (flt[i].equals(
		   "org.w3c.www.protocol.http.proxy.ProxyDispatcher")) {
		//add ProxyDispatcher PropertySet...
		if (server.getPropertySet(PROXY_DISP_PROP_NAME) == null) {
		    p = new ProxyDispatcherProp(PROXY_DISP_PROP_NAME, server);
		    server.registerPropertySet(p);
		}
	    }
	}
    }

    public synchronized void setValue(int idx, Object value) {
	// Check access (we don't care about side effects)
	super.setValue(idx, value);
	if ( idx == ATTR_FILTERS )
	    initializeFiltersProps();
    }

    ProxyProp(String name, httpd server) {
	super(name, server);
	initializeFiltersProps();
    }
}
