/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.AddResourcePanel;
import org.w3c.jigadmin.editors.MiniBrowser;
import org.w3c.jigadmin.editors.RemoteNode;
import org.w3c.jigadmin.editors.RemoteResourceWrapperNode;
import org.w3c.jigadmin.editors.ResourceCell;
import org.w3c.jigadmin.editors.ResourceTreeUI;
import org.w3c.jigadmin.editors.TransferableResourceCell;
import org.w3c.jigadmin.events.ResourceActionEvent;
import org.w3c.jigadmin.events.ResourceActionListener;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigadmin.widgets.Icons;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;

public class ResourceTreeBrowser
extends JTree
implements DropTargetListener,
ResourceActionListener {
    public static final String DELETE_RESOURCE_AC = "delres";
    protected RemoteResourceWrapperNode rootNode = null;
    protected String resIdentifier = null;
    protected String resClassname = null;
    protected JDialog popup = null;
    private boolean isDragging = false;
    TreeWillExpandListener twel = new TreeWillExpandListener(){

        public synchronized void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            ((RemoteNode)((Object)treeNode)).nodeWillCollapse();
            ((DefaultTreeModel)ResourceTreeBrowser.this.getModel()).reload(treeNode);
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            ((RemoteNode)((Object)treeNode)).nodeWillExpand();
            ((DefaultTreeModel)ResourceTreeBrowser.this.getModel()).reload(treeNode);
        }
    };
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(ResourceTreeBrowser.DELETE_RESOURCE_AC)) {
                ResourceTreeBrowser.this.deleteSelectedResources();
            }
        }
    };
    MouseAdapter mouseAdapter = new MouseAdapter(){

        private void maybeShowPopup(MouseEvent mouseEvent) {
            RemoteResourceWrapper remoteResourceWrapper;
            if (mouseEvent.isPopupTrigger() && (remoteResourceWrapper = ResourceTreeBrowser.this.getSelectedResourceWrapper()) != null) {
                ResourceTreeBrowser.this.getPopupMenu(remoteResourceWrapper).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = ResourceTreeBrowser.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = ResourceTreeBrowser.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1) {
                if (mouseEvent.getClickCount() == 1) {
                    ResourceTreeBrowser.this.simpleClick(treePath);
                } else if (mouseEvent.getClickCount() == 2) {
                    ResourceTreeBrowser.this.doubleClick(treePath);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }
    };
    DropTarget dropTarget;
    ActionListener pmal = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTreeBrowser.this.setCursor(3);
            String string = actionEvent.getActionCommand();
            if (string.equals("del")) {
                ResourceTreeBrowser.this.deleteSelectedResources();
            } else if (string.equals("add")) {
                ResourceTreeBrowser.this.addResourceToSelectedContainer();
            } else if (string.equals("reindex")) {
                ResourceTreeBrowser.this.reindexSelectedResources();
            } else if (string.equals("info")) {
                ResourceTreeBrowser.this.showReferenceDocumentation();
            } else if (string.equals("edit")) {
                ResourceTreeBrowser.this.doubleClick(ResourceTreeBrowser.this.getSelectionPath());
            }
            ResourceTreeBrowser.this.setCursor(0);
        }
    };

    protected ResourceTreeBrowser(RemoteResourceWrapperNode remoteResourceWrapperNode) {
        super(remoteResourceWrapperNode);
        this.rootNode = remoteResourceWrapperNode;
        this.dropTarget = new DropTarget(this, this);
        this.setEditable(true);
        this.setLargeModel(true);
        this.setScrollsOnExpand(true);
        this.setUI(new ResourceTreeUI());
        this.addTreeWillExpandListener(this.twel);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.registerKeyboardAction(this.al, DELETE_RESOURCE_AC, keyStroke, 0);
        this.addMouseListener(this.mouseAdapter);
    }

    protected void addResource(String string, String string2, RemoteResourceWrapper remoteResourceWrapper, TreePath treePath) throws RemoteAccessException {
        RemoteResource remoteResource = remoteResourceWrapper.getResource().registerResource(string, string2);
        RemoteResourceWrapper remoteResourceWrapper2 = new RemoteResourceWrapper(remoteResourceWrapper, remoteResource);
        RemoteResourceWrapperNode remoteResourceWrapperNode = (RemoteResourceWrapperNode)treePath.getLastPathComponent();
        RemoteResourceWrapperNode remoteResourceWrapperNode2 = new RemoteResourceWrapperNode(remoteResourceWrapperNode, remoteResourceWrapper2, string);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(remoteResourceWrapperNode2, remoteResourceWrapperNode, 0);
        this.expandPath(treePath);
    }

    protected void addResourceToSelectedContainer() {
        RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        try {
            if (remoteResourceWrapper == null) {
                JOptionPane.showMessageDialog(this, "No Container selected", "Error", 0);
                return;
            }
            if (!propertyManager.isExtensible(remoteResourceWrapper)) {
                JOptionPane.showMessageDialog(this, "The resource selected is not extensible.", "Error", 0);
            } else if (remoteResourceWrapper.getResource().isContainer()) {
                Thread thread = new Thread(){

                    public void run() {
                        ResourceTreeBrowser.this.performAddResourceToSelectedContainer();
                    }
                };
                thread.start();
            } else {
                JOptionPane.showMessageDialog(this, "The resource selected is not container.", "Error", 0);
            }
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void addResourceToSelectedContainer(String string, String string2) throws RemoteAccessException {
        RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
        if (remoteResourceWrapper == null) {
            return;
        }
        this.addResource(string2, string, remoteResourceWrapper, this.getSelectionPath());
    }

    protected void deleteResource(RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        remoteResourceWrapper.getResource().delete();
    }

    protected void deleteSelectedResources() {
        int n;
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        TreePath[] treePathArray = this.removeDescendants(this.getSelectionPaths());
        if (treePathArray == null) {
            JOptionPane.showMessageDialog(this, "No Resource selected", "Error", 0);
            return;
        }
        if (treePathArray.length > 0 && (n = JOptionPane.showConfirmDialog(this, "Delete selected resource(s)?", "Delete Resource(s)", 0)) == 0) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            int n2 = 0;
            while (n2 < treePathArray.length) {
                RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper(treePathArray[n2]);
                if (remoteResourceWrapper != null) {
                    try {
                        Object object;
                        if (propertyManager.isEditable(remoteResourceWrapper)) {
                            this.deleteResource(remoteResourceWrapper);
                            object = (MutableTreeNode)treePathArray[n2].getLastPathComponent();
                            defaultTreeModel.removeNodeFromParent((MutableTreeNode)object);
                        } else {
                            object = (String)remoteResourceWrapper.getResource().getValue("identifier");
                            Message.showInformationMessage(this, String.valueOf(object) + " is not editable");
                        }
                    }
                    catch (RemoteAccessException remoteAccessException) {
                        Message.showErrorMessage((Component)this, remoteAccessException);
                    }
                }
                ++n2;
            }
        }
    }

    protected void disposeAddResourcePopup() {
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    protected void doubleClick(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        RemoteResourceWrapperNode remoteResourceWrapperNode = (RemoteResourceWrapperNode)treePath.getLastPathComponent();
        RemoteResourceWrapper remoteResourceWrapper = remoteResourceWrapperNode.getResourceWrapper();
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        if (propertyManager.isEditable(remoteResourceWrapper)) {
            this.popupResource(remoteResourceWrapperNode.getResourceWrapper());
        } else {
            try {
                String string = (String)remoteResourceWrapper.getResource().getValue("identifier");
                Message.showInformationMessage(this, String.valueOf(string) + " is not editable");
            }
            catch (RemoteAccessException remoteAccessException) {
                Message.showErrorMessage((Component)this, remoteAccessException);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(1);
        this.isDragging = true;
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.isDragging = false;
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.getClosestPathForLocation(point.x, point.y);
        this.setSelectionPath(treePath);
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.isDragging = false;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor dataFlavor = TransferableResourceCell.RESOURCE_CELL_FLAVOR;
        try {
            if (transferable.isDataFlavorSupported(dataFlavor)) {
                dropTargetDropEvent.acceptDrop(1);
                ResourceCell resourceCell = (ResourceCell)transferable.getTransferData(dataFlavor);
                dropTargetDropEvent.dropComplete(this.dropResource(resourceCell));
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    protected boolean dropResource(ResourceCell resourceCell) {
        RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        try {
            String string;
            if (!propertyManager.isExtensible(remoteResourceWrapper)) {
                return false;
            }
            if ((resourceCell.isFrame() || resourceCell.isFilter()) && propertyManager.isEditable(remoteResourceWrapper)) {
                this.popupResource(remoteResourceWrapper);
                return true;
            }
            if (((resourceCell.isContainer() || resourceCell.isResource()) && !remoteResourceWrapper.getResource().isIndexersCatalog() || remoteResourceWrapper.getResource().isIndexersCatalog() && resourceCell.isIndexer()) && remoteResourceWrapper.getResource().isContainer() && (string = this.getIdentifier(resourceCell, remoteResourceWrapper)) != null) {
                TreePath treePath = this.getSelectionPath();
                this.addResource(string, resourceCell.toString(), remoteResourceWrapper, treePath);
                return true;
            }
            return false;
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
            return false;
        }
    }

    protected AddResourcePanel getAddResourcePanel(String string, RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        return new AddResourcePanel(string, remoteResourceWrapper, this);
    }

    protected String getIdentifier(ResourceCell resourceCell, RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        String string = resourceCell.toString();
        string = string.substring(string.lastIndexOf(46) + 1);
        String[] stringArray = remoteResourceWrapper.getResource().enumerateResourceIdentifiers();
        String string2 = string;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals(string2)) {
                string2 = String.valueOf(string) + String.valueOf(++n);
                n2 = 0;
                continue;
            }
            ++n2;
        }
        return string2;
    }

    protected JPopupMenu getPopupMenu(RemoteResourceWrapper remoteResourceWrapper) {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = PropertyManager.getPropertyManager();
            bl = remoteResourceWrapper.getResource().isContainer();
            bl2 = ((PropertyManager)object).isEditable(remoteResourceWrapper);
        }
        catch (RemoteAccessException remoteAccessException) {
            bl = false;
        }
        object = null;
        if (bl) {
            object = new JMenuItem("Reindex", Icons.reindexIcon);
            ((AbstractButton)object).addActionListener(this.pmal);
            ((AbstractButton)object).setActionCommand("reindex");
            jPopupMenu.add((JMenuItem)object);
            object = new JMenuItem("Add resource", Icons.addIcon);
            ((AbstractButton)object).addActionListener(this.pmal);
            ((AbstractButton)object).setActionCommand("add");
            jPopupMenu.add((JMenuItem)object);
        }
        if (bl2) {
            object = new JMenuItem("Delete resource", Icons.deleteIcon);
            ((AbstractButton)object).addActionListener(this.pmal);
            ((AbstractButton)object).setActionCommand("del");
            jPopupMenu.add((JMenuItem)object);
            object = new JMenuItem("Edit resource", Icons.editIcon);
            ((AbstractButton)object).addActionListener(this.pmal);
            ((AbstractButton)object).setActionCommand("edit");
            jPopupMenu.add((JMenuItem)object);
            jPopupMenu.addSeparator();
        }
        object = new JMenuItem("Info", Icons.infoIcon);
        ((AbstractButton)object).addActionListener(this.pmal);
        ((AbstractButton)object).setActionCommand("info");
        jPopupMenu.add((JMenuItem)object);
        return jPopupMenu;
    }

    public static ResourceTreeBrowser getResourceTreeBrowser(RemoteResourceWrapper remoteResourceWrapper, String string) {
        RemoteResourceWrapperNode remoteResourceWrapperNode = new RemoteResourceWrapperNode(remoteResourceWrapper, string);
        ResourceTreeBrowser resourceTreeBrowser = new ResourceTreeBrowser(remoteResourceWrapperNode);
        return resourceTreeBrowser;
    }

    protected RemoteResourceWrapper getSelectedResourceWrapper() {
        RemoteResourceWrapperNode remoteResourceWrapperNode = (RemoteResourceWrapperNode)this.getLastSelectedPathComponent();
        if (remoteResourceWrapperNode == null) {
            return null;
        }
        return remoteResourceWrapperNode.getResourceWrapper();
    }

    protected RemoteResourceWrapper getSelectedResourceWrapper(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        RemoteResourceWrapperNode remoteResourceWrapperNode = (RemoteResourceWrapperNode)treePath.getLastPathComponent();
        return remoteResourceWrapperNode.getResourceWrapper();
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    private void performAddResourceToSelectedContainer() {
        block2: {
            this.popupAddResourceDialog("Add Resource", this.getSelectedResourceWrapper());
            if (this.resIdentifier == null || this.resClassname == null) break block2;
            try {
                this.addResourceToSelectedContainer(this.resClassname, this.resIdentifier);
            }
            catch (RemoteAccessException remoteAccessException) {
                Message.showErrorMessage((Component)this, remoteAccessException);
            }
        }
    }

    protected void popupAddResourceDialog(String string, RemoteResourceWrapper remoteResourceWrapper) {
        try {
            AddResourcePanel addResourcePanel = this.getAddResourcePanel(string, remoteResourceWrapper);
            JFrame jFrame = this.rootNode.getResourceWrapper().getServerBrowser().getFrame();
            this.popup = new JDialog(jFrame, string, false);
            Container container = this.popup.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            container.add(addResourcePanel);
            ((Component)this.popup).setSize(new Dimension(600, 220));
            this.popup.show();
            addResourcePanel.getFocus();
            while (!addResourcePanel.waitForCompletion()) {
            }
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void popupResource(RemoteResourceWrapper remoteResourceWrapper) {
        remoteResourceWrapper.getServerBrowser().popupResource(remoteResourceWrapper);
    }

    protected void reindexResource(RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        RemoteResource remoteResource = remoteResourceWrapper.getResource();
        if (remoteResource.isContainer()) {
            remoteResource.reindex();
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(remoteResource.getValue("identifier"))) + " is not a container.", "Error", 0);
        }
    }

    protected void reindexSelectedResources() {
        int n;
        TreePath[] treePathArray = this.removeDescendants(this.getSelectionPaths());
        if (treePathArray == null) {
            JOptionPane.showMessageDialog(this, "No Container selected", "Error", 0);
            return;
        }
        if (treePathArray.length > 0 && (n = JOptionPane.showConfirmDialog(this, "Reindex selected resource(s)?", "Reindex Resource(s)", 0)) == 0) {
            int n2 = 0;
            while (n2 < treePathArray.length) {
                RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper(treePathArray[n2]);
                if (remoteResourceWrapper != null) {
                    try {
                        this.reindexResource(remoteResourceWrapper);
                    }
                    catch (RemoteAccessException remoteAccessException) {
                        Message.showErrorMessage((Component)this, remoteAccessException);
                    }
                }
                ++n2;
            }
        }
    }

    protected TreePath[] removeDescendants(TreePath[] treePathArray) {
        Object[] objectArray;
        if (treePathArray == null) {
            return null;
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < treePathArray.length) {
            objectArray = treePathArray[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < treePathArray.length) {
                if (n2 != n && treePathArray[n2].isDescendant((TreePath)objectArray)) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                vector.addElement(objectArray);
            }
            ++n;
        }
        objectArray = new TreePath[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void resourceActionPerformed(ResourceActionEvent resourceActionEvent) {
        int n = resourceActionEvent.getResourceActionCommand();
        if (this.isShowing()) {
            if (n == 10) {
                this.deleteSelectedResources();
            } else if (n == 30) {
                this.reindexSelectedResources();
            } else if (n == 60) {
                this.showReferenceDocumentation();
            } else if (n == 20) {
                this.addResourceToSelectedContainer();
            } else if (n == 70) {
                this.doubleClick(this.getSelectionPath());
            }
        }
    }

    protected void setCursor(int n) {
        this.rootNode.getResourceWrapper().getServerBrowser().setCursor(n);
    }

    protected void setResourceToAdd(String string, String string2) {
        this.resClassname = string;
        this.resIdentifier = string2;
    }

    protected void showReferenceDocumentation() {
        try {
            RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
            if (remoteResourceWrapper == null) {
                JOptionPane.showMessageDialog(this, "No Resource selected", "Error", 0);
                return;
            }
            String string = (String)remoteResourceWrapper.getResource().getValue("help-url");
            MiniBrowser.showDocumentationURL(string, "Reference documentation");
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
        catch (Exception exception) {}
    }

    protected void simpleClick(TreePath treePath) {
    }
}

