/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.editors.AttributesHelper;
import org.w3c.jigadmin.editors.FrameBrowser;
import org.w3c.jigadmin.editors.MiniBrowser;
import org.w3c.jigadmin.editors.RemoteFrameWrapperNode;
import org.w3c.jigadmin.editors.ResourceHelper;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigadmin.widgets.Icons;
import org.w3c.jigsaw.admin.RemoteAccessException;

public class FramedResourceHelper
extends ResourceHelper {
    protected String name = null;
    protected JPanel comp = null;
    protected JPanel attrs = null;
    protected org.w3c.jigadmin.RemoteResourceWrapper rrw = null;
    protected org.w3c.jigadmin.RemoteResourceWrapper selected_rrw = null;
    protected FrameBrowser browser = null;
    TreeSelectionListener tsl = new TreeSelectionListener(){
        org.w3c.jigadmin.RemoteResourceWrapper current_rrw = null;

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.isAddedPath()) {
                if (!FramedResourceHelper.this.browser.isDragging()) {
                    org.w3c.jigadmin.RemoteResourceWrapper remoteResourceWrapper;
                    RemoteFrameWrapperNode remoteFrameWrapperNode = (RemoteFrameWrapperNode)treeSelectionEvent.getPath().getLastPathComponent();
                    this.current_rrw = remoteResourceWrapper = remoteFrameWrapperNode.getResourceWrapper();
                    Thread thread = new Thread(FramedResourceHelper.this, this){
                        private final /* synthetic */ FramedResourceHelper this$0;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$0 = framedResourceHelper;
                            this.this$1 = var2_2;
                        }

                        public void run() {
                            this.this$0.updateAttrs(this.this$1.current_rrw);
                        }
                    };
                    thread.start();
                } else {
                    FramedResourceHelper.this.attrs.invalidate();
                    FramedResourceHelper.this.attrs.removeAll();
                    FramedResourceHelper.this.attrs.add(new JLabel(" ", 0));
                    FramedResourceHelper.this.attrs.validate();
                }
            } else {
                FramedResourceHelper.this.selected_rrw = null;
                FramedResourceHelper.this.attrs.invalidate();
                FramedResourceHelper.this.attrs.removeAll();
                FramedResourceHelper.this.attrs.add(new JLabel("no frame selected", 0));
                FramedResourceHelper.this.attrs.validate();
            }
        }
    };

    protected void build(boolean bl) {
        this.comp = new JPanel(new GridLayout(1, 1));
        this.attrs = new JPanel(new GridLayout(1, 1));
        this.attrs.setBorder(BorderFactory.createTitledBorder("Attributes"));
        if (bl) {
            this.browser = FrameBrowser.getFrameBrowser(this.rrw, this.name);
            this.browser.addTreeSelectionListener(this.tsl);
            this.browser.setSelectionRow(0);
            this.browser.setBorder(BorderFactory.createTitledBorder("Frames"));
            this.browser.setSize(new Dimension(30, 30));
            JScrollPane jScrollPane = new JScrollPane(this.browser);
            JSplitPane jSplitPane = new JSplitPane(0, true, jScrollPane, this.attrs);
            jSplitPane.setDividerLocation(100);
            this.comp.add(jSplitPane);
        } else {
            this.comp.add(this.attrs);
            this.updateAttrs(this.rrw);
        }
    }

    public void clearChanged() {
    }

    public void commitChanges() throws RemoteAccessException {
    }

    public Component getComponent() {
        return this.comp;
    }

    public JMenuBar getMenuBar(Window window) {
        return new ResourceMenu(window);
    }

    public String getTitle() {
        return "Frames";
    }

    public boolean hasChanged() {
        return false;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Properties properties) throws RemoteAccessException {
        boolean bl = false;
        this.rrw = (org.w3c.jigadmin.RemoteResourceWrapper)remoteResourceWrapper;
        try {
            this.name = (String)this.rrw.getResource().getValue("identifier");
            bl = this.rrw.getResource().isFramed();
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage(this.rrw, remoteAccessException);
        }
        if (this.name == null) {
            this.comp = new JPanel();
            return;
        }
        this.build(bl);
    }

    public void resetChanges() {
    }

    protected void updateAttrs(org.w3c.jigadmin.RemoteResourceWrapper remoteResourceWrapper) {
        this.selected_rrw = remoteResourceWrapper;
        this.attrs.invalidate();
        this.attrs.removeAll();
        AttributesHelper attributesHelper = new AttributesHelper();
        try {
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Properties properties = propertyManager.getEditorProperties(remoteResourceWrapper);
            attributesHelper.initialize(remoteResourceWrapper, properties);
            this.attrs.add(attributesHelper.getComponent());
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
        }
        this.attrs.validate();
    }

    class ResourceMenu
    extends JMenuBar
    implements ActionListener {
        private Window parent = null;
        static final String CLOSE_AC = "quit";
        static final String DEL_AC = "del";
        static final String ADD_AC = "add";
        static final String DOC_AC = "doc";

        ResourceMenu(Window window) {
            this.parent = window;
            JMenu jMenu = new JMenu("Resource");
            this.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem("Add frame to selected resource/frame", Icons.addIcon);
            jMenuItem.setActionCommand(ADD_AC);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Delete selected frame(s)", Icons.deleteIcon);
            jMenuItem2.setActionCommand(DEL_AC);
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            jMenu.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem("Close Resource window", Icons.closeIcon);
            jMenuItem3.setActionCommand(CLOSE_AC);
            jMenuItem3.addActionListener(this);
            jMenu.add(jMenuItem3);
            JMenu jMenu2 = new JMenu("Help");
            this.add(jMenu2);
            JMenuItem jMenuItem4 = new JMenuItem("Show reference documentation", Icons.infoIcon);
            jMenuItem4.setActionCommand(DOC_AC);
            jMenuItem4.addActionListener(this);
            jMenu2.add(jMenuItem4);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CLOSE_AC)) {
                this.parent.dispose();
            } else if (string.equals(DOC_AC) && FramedResourceHelper.this.selected_rrw != null) {
                try {
                    String string2 = (String)FramedResourceHelper.this.selected_rrw.getResource().getValue("help-url");
                    this.showReference(string2);
                }
                catch (RemoteAccessException remoteAccessException) {
                    remoteAccessException.printStackTrace();
                }
            } else if (string.equals(DEL_AC) && FramedResourceHelper.this.selected_rrw != null) {
                FramedResourceHelper.this.browser.deleteSelectedResources();
            } else if (string.equals(ADD_AC) && FramedResourceHelper.this.selected_rrw != null) {
                FramedResourceHelper.this.browser.addResourceToSelectedContainer();
            }
        }

        protected void showReference(String string) {
            try {
                MiniBrowser.showDocumentationURL(string, "Reference documentation");
            }
            catch (Exception exception) {
                Message.showErrorMessage((Component)this, exception);
            }
        }
    }
}

