/*
 * unix.c
 * $Id: unix.c,v 1.2 1998/02/04 15:23:49 ylafon Exp $
 */
    
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>

#include <StubPreamble.h>
#include <javaString.h>

#include "org_w3c_util_Unix.h"

/**
 * Get the user id, given the user name.
 * returns: 
 *   -1  if user not found, or any other error.
 *   uid otherwise.
 */

long org_w3c_util_Unix_getUID0(struct Horg_w3c_util_Unix *self
			       , struct Hjava_lang_String *hsUser) {
    char          *user  = makeCString(hsUser);
    struct passwd *pwusr;
    
    if ((pwusr = getpwnam(user)) == NULL)
	return -1;
    return pwusr->pw_uid;
}

/**
 * Get the group id, given the group name.
 * returns: 
 *   -1  if group not found, or any other error.
 *   gid otherwise.
 */

long org_w3c_util_Unix_getGID0(struct Horg_w3c_util_Unix *self
			       ,struct Hjava_lang_String *hsGroup) {
    char *group = makeCString(hsGroup);
    struct group *grp;
    
    if ((grp = getgrnam(group)) == NULL)
	return -1;
    return grp->gr_gid;
}

/*boolean*/ 
long org_w3c_util_Unix_setUID0(struct Horg_w3c_util_Unix *self
			       , long luid) {
    return (setuid((int) luid) < 0) ? FALSE : TRUE;
}

/*boolean*/ 
long org_w3c_util_Unix_setGID0(struct Horg_w3c_util_Unix *self
			       , long lgid) {
    return (setgid((int) lgid) < 0) ? FALSE : TRUE;
}

/*boolean*/ 
long org_w3c_util_Unix_chroot0(struct Horg_w3c_util_Unix *self
			       ,struct Hjava_lang_String *hsRoot) {
    char *root = makeCString(hsRoot);
    return (chroot(root) < 0) ? FALSE : TRUE;
}
