// cacheStatistics.java
// $Id: cacheStatistics.java,v 1.1 1996/10/01 18:42:42 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.www.protocol.http.cache;

public class cacheStatistics {
    /**
     * Number of cache hits.
     */
    protected int hits = 0;
    /**
     * Number of cache misses.
     */
    protected int misses = 0;
    /**
     * Number of succesfull revalidations.
     */
    protected int goodRevalidations = 0;
    /**
     * Number of unsuccessfull revalidations.
     */
    protected int badRevalidations = 0;
    /**
     * The start time, as aa number of milliseconds since Java epoch.
     */
    protected long start_time = 0;

    /**
     * Increment the number of hits.
     */

    protected final synchronized void incrHits() {
	hits++;
    }

    /**
     * Increment the number of misses.
     */

    protected final synchronized void incrMisses() {
	misses++;
    }

    /**
     * Increment the number of good revalidations.
     */

    protected final synchronized void incrGoodRevalidations() {
	goodRevalidations++;
    }

    /**
     * Increment the number of bad revalidations.
     */

    protected final synchronized void incrBadRevalidations() {
	badRevalidations++;
    }

    /**
     * Get the number of successfull hits.
     * A hit is sucessfull if a cache entry for the target existed <em>before
     * </em> that request. A successfull hit can then account for either 
     * no revalidation at all, a good or a bad revalidation (but at least for
     * one of these).
     * @return The number of hits.
     */

    public int getHits() {
	return hits;
    }

    /**
     * Get the number of cache misses.
     * A miss happens one a request is made for a resource that doesn't exist
     * in the cache yet.
     * @return The number of misses.
     */

    public int getMisses() {
	return misses;
    }

    /**
     * Number of good revalidations.
     * A good revalidation is revalidation for which the origin server emitted
     * a <code>NOT_MODIFIED</code> status code.
     * @return The number of good revalidations.
     */

    public int getGoodRevalidations() {
	return goodRevalidations;
    }

    /**
     * Number of bad revalidations.
     * A bad revalidation is a revalidation that triggered a full reply from
     * the origin server.
     * @return The number of bad revalidations.
     */

    public int getBadRevalidations() {
	return badRevalidations;
    }

    /**
     * Get the start time as the number of milliseconds since Java epoch.
     * @return A long number of milliseconds.
     */

    public long getStartTime() {
	return start_time;
    }

    cacheStatistics() {
	start_time = System.currentTimeMillis();
    }

}
