// RequestFilter.java
// $Id: RequestFilter.java,v 1.2 1996/07/26 23:25:00 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.www.protocol.http;

/**
 * The request filter interface.
 * Filters allow application wide request enhancement before they are being
 * actually emited on the wire. 
 * <p>Once registered to the HttpManager, a request filter will be invoked
 * <em>before</em> the request is actualy sent to the wire, and right
 * <em>after</em> the reply headers are available, <em>only</em> if its
 * current scope matches the request URL.
 */

public interface RequestFilter {

    /**
     * The request pre-processing hook.
     * Before each request is launched, all filters will be called back through
     * this method. They will generally set up additional request header
     * fields to enhance the request.
     * @param request The request that is about to be launched.
     * @return An instance of Reply if the filter could handle the request,
     * or <strong>null</strong> if processing should continue normally.
     */

    public Reply ingoingFilter(Request request) 
	throws HttpException;

    /**
     * The request post-processing hook.
     * After each request has been replied to by the target server (be it a 
     * proxy or the actual origin server), each filter's outgoingFilter
     * method is called.
     * <p>It gets the original request, and the actaul reply as a parameter,
     * and should return whatever reply it wants the caller to get.
     * @param request The original (handled) request.
     * @param reply The reply, as emited by the target server, or constructed
     * by some other filter.
     */

    public Reply outgoingFilter(Request request, Reply reply) 
	throws HttpException;

}
