// Request.java
// $Id: Request.java,v 1.5 1996/09/06 22:39:39 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.www.protocol.http;

import java.io.*;

import w3c.util.*;
import w3c.www.http.*;

/**
 * The client side idea of a request.
 * Requests are created only by the HttpManager, by cloning its template 
 * request that defines the default (application wide) request settings.
 */

public class Request extends HttpRequestMessage {
    /**
     * The manager that created this request.
     */
    protected HttpManager manager = null;
    /**
     * Are we allowed to interact with the user ?
     */
    protected boolean allowuserinteraction = false;
    /**
     * The request output stream, to PUT or POST data.
     */
    protected InputStream output = null;
    /**
     * The observer for the request, if any.
     */
    protected RequestObserver observer = null;
    /**
     * End of header emiting, continue by sending optional output stream.
     * @param out The output stream to write to.
     */

    protected void endEmit(OutputStream out, int what) 
	throws IOException 
    {
	if ((what & EMIT_BODY) != EMIT_BODY)
	    return;
	if ( output != null ) {
	    byte buf[] = new byte[1024];
	    int  cnt   = 0;
	    int total  = 0;
	    while ((cnt = output.read(buf)) > 0) {
		total +=cnt;
		out.write(buf, 0, cnt);
	    }
	    output.close();
	}
	return;
    }

    /**
     * Are we allowed to do some user interaction to run this request.
     * @return A boolean, <strong>true</strong> if user interaction is allowed
     * <strong>false</strong> otherwise.
     */

    public boolean getAllowUserInteraction() {
	return allowuserinteraction;
    }

    /**
     * Decide wether we are allowed to interact wit hthe user.
     * @param onoff A boolean, <strong>true</strong> if interaction is allowed.
     */

    public void setAllowUserInteraction(boolean onoff) {
	allowuserinteraction = onoff;
    }

    /**
     * Get this request's manager.
     * @return The instance of the manager taking care of this request.
     */

    public HttpManager getManager() {
	return manager;
    }

    /**
     * Set this request output stream.
     * @param in The data to send to the server.
     */

    public void setOutputStream(InputStream in) {
	this.output = in;
    }

    /**
     * Does this request has an associated input stream ?
     * @return A boolean <strong>true</strong> of it has.
     */

    public boolean hasOutputStream() {
	return output != null;
    }
     
    /**
     * Create a Reply instance matching this request.
     */

    public Reply makeReply(int status) {
	return new Reply(major, minor, status);
    }

    /**
     * Set the observer for this request.
     * @param observer The observer.
     */

    public void setObserver(RequestObserver observer) {
	this.observer = observer;
    }

    /**
     * Get the observer for this request.
     * @return An instance of RequestObserver, or <strong>null</strong> 
     * if undefined.
     */

    public RequestObserver getObserver() {
	return observer;
    }

    Request(HttpManager manager) {
	super();
	this.manager = manager;
    }

}
