// DebugFilter.java
// $Id: DebugFilter.java,v 1.3 1996/07/26 23:24:55 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html


package w3c.www.protocol.http;

import java.io.*;

/**
 * A simple debug filter, that will dump traffic
 * This filter will dump the outgoing request, and the incomming reply to
 * the java process standard output.
 * <p>Usefull for debugging !
 */

public class DebugFilter implements PropRequestFilter {

    /**
     * PropRequestFilter implementation - Initialize the filter.
     * Time to register ourself to the HttpManager.
     * @param manager The HTTP manager that is initializing ourself.
     */

    public void initialize(HttpManager manager) {
	// We install ourself as a global filter, we are cool !
	manager.setFilter(this);
    }
     
    /**
     * The ingoing filter just dumps the request.
     * @param request The request to be filtered.
     * @exception HttpException is never thrown.
     */

    public Reply ingoingFilter(Request request) 
	throws HttpException
    {
	// On the way in, emit the request to stdout:
	request.dump(System.out);
	return null;
    }
    
    /**
     * The outgoing filter just dumps the reply.
     * @param request The request that is filtered.
     * @param reply The corresponding reply.
     * @exception HttpException is never thrown.
     */

    public Reply outgoingFilter(Request Request, Reply reply) 
	throws HttpException
    {
	// On the way out, emit the reply to stdou:
	reply.dump(System.out);
	return null;
    }

}
