// SegmentArrayAttribute.java
// $Id: SegmentArrayAttribute.java,v 1.5 1996/08/22 19:07:51 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.io.* ;
import java.util.* ;

import w3c.jigsaw.resources.* ;


/**
 * Attribute used to make the document segment information persistent.
 * @author Antonio Ramirez <anto@mit.edu>
 */ 
class SegmentArrayAttribute extends Attribute {
    
    public boolean checkValue(Object value)
    {
	return value instanceof Segment[] ;
    }

    public void pickle(DataOutputStream out,Object obj)
	throws IOException
    {
	Segment[] segs = (Segment[]) obj ;
	out.writeInt(segs.length);
	for(int i=0;i<segs.length;i++) 
	    segs[i].pickle(out) ;
    }

    public Object unpickle(DataInputStream in)
	throws IOException
    {
	int n = in.readInt() ;
	
	Segment segs[] = new Segment [n] ;

	for(int i=0;i<n;i++)
	    segs[i] = Segment.unpickle(in) ;
	
	return segs ;
    }

    public SegmentArrayAttribute(String name, Segment[] def, int flags)
    {
	super(name,def,flags) ;
    }

    public String stringify(Object value)
    {
	Segment[] segs = (Segment[]) value ;
	StringBuffer buf = new StringBuffer(160) ;
	buf.append('[') ;
	for(int i=0;i<segs.length;i++) {
	    buf.append(segs[i].toString()) ;
	    buf.append(' ') ;
	}
	buf.append(']') ;
	return buf.toString() ;
    }
}
