// CountCommand.java
// $Id: CountCommand.java,v 1.8 1996/08/22 19:07:44 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.util.* ;

import w3c.www.http.HTTP ;
import w3c.util.* ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.http.* ;


/**
 * This command inserts the number of recorded accesses to this resource,
 * as reported by w3c.jigsaw.filter.CounterFilter.
 * @see w3c.jigsaw.filter.CounterFilter
 * @author Antonio Ramirez <anto@mit.edu>
 */
public class CountCommand extends BasicCommand {
    private static final String NAME = "hitcount" ;
    
    public Reply execute(SSIResource resource,
			 Request request,
			 ArrayDictionary parameters,
			 Dictionary variables)
    {
	Reply reply =
	    resource.createCommandReply(request,HTTP.OK) ;
	
	Integer count = (Integer)
	    request.getState(w3c
			     .jigsaw
			     .filters
			     .CounterFilter
			     .STATE_COUNT) ;
	if(count == null)
	    reply.setContent("[unknown]") ;
	else reply.setContent(count.toString()) ;

	// FIXME, NOTE:
	// the handling of weak validation should be configurable
	handleSimpleIMS(request,reply) ;
	return reply ;
    }			 

    public String getName()
    {
	return NAME ;
    }
}
