// CommandRegistry.java
// $Id: CommandRegistry.java,v 1.8 1996/09/05 02:41:51 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.util.* ;

import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;


/**
 * This class represents a group of SSI commands.  This is an abstract
 * class.  A concrete subclass of this class is supplied to the
 * SSIResource for finding the commands present in the document.
 *
 * @see w3c.jigsaw.ssi.BasicCommandRegistry
 * @see w3c.jigsaw.ssi.DefaultCommandRegistry
 * @author Antonio Ramirez <anto@mit.edu>
 */

public abstract class CommandRegistry {
    /** 
     * Look up a command from its name.
     * (Should <em>never</em> return null, and have a pseudo-command
     * to handle non-existent commands).
     *
     * @param name the name
     * @return the command
     */
    public abstract Command lookupCommand(String name) ;

    /**
     * Initialize execution variables.  Called before any of the SSI
     * commands in the documents are executed.  This method augments
     * or modifies the dictionary given as argument.  If the variable
     * dictionary is null, it may create a new one and return it.
     * SSIResource will always call this method with variables set to
     * null. Its existence is mainly to facilitate the subclassing of
     * an existing registry.
     *
     * @param request the HTTP request
     * @param variables other variables previously defined
     * @return the modified/augmented set of variables */
    public abstract Dictionary initVariables(SSIResource resource,
					     Request request,
					     Dictionary variables) ;
}

