// PropertiesAttribute.java
// $Id: PropertiesAttribute.java,v 1.1 1996/09/19 16:01:49 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;
import java.util.*;

import w3c.util.*;

/**
 * The generic description of an PropertiesAttribute.
 * A PropertiesAttribute instance holds a String to String mapping, it
 * should be used only with care, since people may act on a reference to
 * it.
 */

public class PropertiesAttribute extends Attribute {

    /**
     * Is the given object a valid PropertiesAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if value is valid.
     */

    public boolean checkValue(Object obj) {
	return (obj == null) || (obj instanceof ArrayDictionary);
    }
     
    /**
     * Pickle a property list to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object o) 
	throws IOException
    {
	ArrayDictionary a = (ArrayDictionary) o;
	Enumeration     e = a.keys();
	int             s = a.size();
	out.writeInt(s);
	while (--s >= 0) {
	    String key = (String) e.nextElement();
	    out.writeUTF(key);
	    out.writeUTF((String) a.get(key));
	}
    }

    /**
     * Unpickle an string from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of String.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	int             s = in.readInt();
	ArrayDictionary a = new ArrayDictionary(s, 5);
	while (--s >= 0) {
	    String k = in.readUTF();
	    String v = in.readUTF();
	    a.put(k, v);
	}
	return a;
    }
     
    /**
     * Create a description for a generic property list attribute.
     * @param name The attribute name.
     * @param def The default value for these attributes.
     * @param flags The associated flags.
     */

    public PropertiesAttribute(String name, String def, int flags) {
	super(name, def, flags) ;
    }

}

