// AttributeHolderAttribute.java
// $Id: AttributeHolderAttribute.java,v 1.1 1996/08/09 15:05:41 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an attribute whose value is an attribute holder.
 */

public class AttributeHolderAttribute extends Attribute {

    /**
     * Is the given object a valid AttributeHolder value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof AttributeHolder) || (obj == null) ;
    }
     
    /**
     * Pickle an attribute holder to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object ah) 
	throws IOException
    {
	((AttributeHolder) ah).pickle(out);
    }

    /**
     * Unpickle an attribute holder from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An AttributeHolder instance.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	return AttributeHolder.unpickle(in);
    }
     
    public AttributeHolderAttribute(String name
				    , AttributeHolder def
				    , int flags) {
	super(name, def, flags) ;
    }

}
