// LoggingProp.java
// $Id: LoggingProp.java,v 1.5 1996/10/03 21:19:14 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

import java.io.* ;
import java.util.* ;

import w3c.jigsaw.config.*;
import w3c.jigsaw.resources.*;

/**
 * A wrapper class to give access to editable properties through a resource.
 * This class allows to reuse entirely the generic resource editor to
 * edit the properties of the server.
 */

class LoggingProp extends PropertySet {
    private static String title = "Logging properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.jigsaw.http.LoggingProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// The class of the logger:
	a = new ClassAttribute(httpd.LOGGER_P
			       , null
			       , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// The error log file:
	a = new FileAttribute(CommonLogger.ERRLOGNAME_P
			      , null
			      , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// The normal log:
	a = new FileAttribute(CommonLogger.LOGNAME_P
			      , null
			      , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// The trace log:
	a = new FileAttribute(CommonLogger.TRACELOGNAME_P
			      , null
			      , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
	// The log buffer size:
	a = new IntegerAttribute(CommonLogger.BUFSIZE_P
				 , new Integer(8192)
				 , Attribute.EDITABLE|Attribute.DONTSAVE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    LoggingProp(String name, httpd server) {
	super(name, server);
    }
}

