// HtmlGenerator.java
// $Id: HtmlGenerator.java,v 1.4 1996/08/09 15:02:15 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.html ;

import java.io.* ;
import w3c.www.mime.*;

/**
 * A simple HTML generator.
 * This class implements an HTML generator that allows to output dynamic
 * HTML content out.
 */

public class HtmlGenerator {
    private static MimeType type = MimeType.TEXT_HTML;

    String       title   = null ;
    StringBuffer body    = null ;
    StringBuffer meta    = null ;
    String       content = null ;	// content once closed.
    boolean      bodytag = true ;       // frameset hack

    /**
     * Get this stream MIME type.
     * This defaults to <strong>text/html</strong>.
     */

    public MimeType getMimeType () {
	return type ;
    }

    /**
     * Don't emit body tag. This is usefull in conjunction with the FRAMESET
     * tag, that requires that no BODY tag be emited.
     * @param value If <strong>true</strong>, a BODY tag will be emited.
     */

    public void emitBODYTag (boolean value) {
	this.bodytag = value ;
    }

    /**
     * Append the given string, escaping all special characters. This can be 
     * used only if you know that the string you are inserting doesn't contain
     * HTML tags
     */

    public void appendAndEscape (String content) {
	for (int i = 0 ; i < content.length() ; i++) {
	    char ch = content.charAt(i) ;
	    switch (ch) {
	      case '<': body.append ("&lt;") ; break ;
	      case '>': body.append ("&gt;") ; break ;
	      default:  body.append (ch) ; break;
	    }
	}
    }

    /**
     * Append the given string to the document body.
     * @param The HTML string to append.
     */

    public void append (String content) {
	body.append (content) ;
    }

    /**
     * Append the two strings to the document body.
     * <code>append("x"+"y");</code> is equivalent but slower than
     * <code>append("x", "y");</code>.
     * @param str1 The first string.
     * @param str2 The second string.
     */

    public void append(String str1, String str2) {
	body.append(str1) ;
	body.append(str2) ;
    }

    public void append(String s1, String s2, String s3) {
	body.append(s1);
	body.append(s2);
	body.append(s3);
    }

    /**
     * Get the length of this html document
     * @return the length in bytes of the document
     */
    
    public int length () {
	if ( content == null )
	    close () ;
	return content.length() ;
    }

    /**
     * Close the given document: its composition is now finished.
     * @return	The content length for this document.
     */

    public void close () {
	if ( content != null )
	    return ;
	content = "<html><head>"
	    + ((meta != null) ? meta.toString() : "")
	    + "<title>" + title + "</title>"
	    + "</head>"
	    + (bodytag 
	       ? ("<body>" + body.toString() + "</body>")
	       : body.toString())
	    + "</html>" ;
	return ;
    }

    public void meta (String name, String value) {
	if ( this.meta == null ) {
	    this.meta = new StringBuffer ("<meta http-equiv=\""
					  + name
					  + "\" content=\""
					  + value +"\">") ;
	} else {
	    this.meta.append ("<meta http-equiv=\""
			      + name
			      + "\" content=\""
			      + value
			      + "\">") ;
	}
    }
    
    /**
     * Get the input string for reading the document.
     * @return An input stream to get the generated document from.
     */
    
    public InputStream getInputStream () {
	close() ;
	return new StringBufferInputStream (content) ;
    }

    public HtmlGenerator (String title) {
	this.title = title ;
	this.body  = new StringBuffer() ;
    }
}
