// PropertiesField.java
// $Id: PropertiesField.java,v 1.1 1996/09/25 14:14:47 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms;

import java.util.* ;

import w3c.jigsaw.html.HtmlGenerator ;
import w3c.util.*;

public class PropertiesField extends TextArrayField {

    /**
     * Get this field's value.
     */

    public Object getValue() {
	return value ;
    }

    /**
     * Parse the given \r or \n sparated list of items into an array of items.
     * @param str The string to parse.
     * @return An array of String.
     */

    protected Object parseString(String str) {
	StringTokenizer st      = new StringTokenizer(str, "\r\n") ;
	int             count   = st.countTokens();

	// Check for null value:
	if ( count == 0 )
	    return null ;
	// get all the tokens:
	ArrayDictionary d = new ArrayDictionary(count, 5);
	for (int iptr = 0 ; iptr < count ; iptr++) {
	    String          assoc = st.nextToken();
	    StringTokenizer split = new StringTokenizer(assoc, " \t");
	    String key = split.nextToken();
	    String val = split.nextToken();
	    d.put(key, val);
	}
	return d ;
    }

    protected boolean differs(Object o1, Object o2) {
	if ((o1 == null) && (o2 == null))
	    return false;
	Dictionary a1 = (Dictionary) o1;
	Dictionary a2 = (Dictionary) o2;
	if (a1.size() == a2.size()) {
	    Enumeration e = a1.keys();
	    while (e.hasMoreElements()) {
		String k1 = (String) e.nextElement();
		String v1 = (String) a1.get(k1);
		String v2 = (String) a2.get(k1);
		if ( ! v2.equals(v1) )
		    return true;
	    }
	    return false;
	}
	return true;
    }

    /**
     * Compute the string to display for the given list of items
     */

    protected String computeString(Object v) {
	if ( v == null )
	    return null ;
	ArrayDictionary d  = (ArrayDictionary) v;
	StringBuffer    sb = new StringBuffer() ;
	Enumeration     e  = d.keys();
	while ( e.hasMoreElements() ) {
	    String key = (String) e.nextElement();
	    sb.append(key+" "+d.get(key)+"\r\n");
	}
	return sb.toString() ;
    }

    /*
     * Initialize a PropertiesField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (ArrayDictionary) val ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
	this.strval = computeString(this.value) ;
    }


    public PropertiesField (String name, String title, String url
			    , ArrayDictionary value) {
	super (name, title, url) ;
	this.value  = value ;
	this.strval = computeString(this.value) ;
    }

    public PropertiesField() {
    }

}
