// MimeTypeField.java
// $Id: MimeTypeField.java,v 1.1 1996/08/09 15:01:52 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import java.util.* ;
import java.io.* ;

import w3c.www.mime.* ;
import w3c.jigsaw.html.HtmlGenerator ;

public class MimeTypeField extends FormField {
    MimeType value = MimeType.TEXT_HTML ;

    /**
     * Get this field value as an Object.
     * @return An instance of Object.
     */

    public Object getValue () {
	return value ;
    }

    /**
     * Set the fields value, as a MIME type.
     * This method doesn't notify the form handler.
     * @param value The MimeType value.
     */

    public void setValue (MimeType tval) {
	value = tval ;
    }

    /**
     * Set this field value to the given MIMEType value, provided as a String.
     * If the value is changed, than the handler for this field is notified
     * of the change through an appropriate method call.
     * @param nval The new string encoded mime type for this field.
     * @return A boolean, <strong>true</strong> indicates that the field value
     *    has effectively changed.
     * @exception FormFieldException If the provided value didn't match
     *    the expected type for this field.
     */

    public boolean setValue (String nval) 
	throws FormFieldException
    {
	if ((nval == null) || nval.equals("")) {
	    boolean result = (value != null) ;
	    value = null ;
	    return result ;
	}
	if ((value != null) && nval.equalsIgnoreCase (value.toString()) ) 
	    return false ;
	try {
	    value = new MimeType(nval) ;
	} catch (MimeTypeFormatException ex) {
	    throw new FormFieldException ("Invalid mime type: "+nval) ;
	}
	return true ;
    }

    /**
     * Dump this field has a form element.
     * @param into The HtmlGenerator to dump the field to.
     */

    public void dump (HtmlGenerator into) {
	dumpTitle(into) ;
	into.append ("<th align=left><input type=\"text\""
		     + " name=\""+name+"\""
		     + " size=\"32\""
		     + ((value != null) ? " value=\""+value.toString() : "")
		     + "\">") ;

    }

    /*
     * Initialize a MimeTypeField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (MimeType) val;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }

					   
    public MimeTypeField (String name,String title,String url, MimeType tval) {
	super (name, title, url) ;
	this.value = tval ;
    }

    public MimeTypeField() {
    }

}
