// FileField.java
// $Id: FileField.java,v 1.1 1996/04/10 13:41:39 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import java.io.*;

import w3c.jigsaw.html.* ;

public class FileField extends FormField {
    File value = null ;

    /**
     * Get this field value as an Object.
     * @return An instance of Object.
     */

    public Object getValue () {
	return value ;
    }

    /**
     * Set this field value to the given String value.
     * If the value is changed, than the handler for this field is notified
     * of the change through an appropriate method call.
     * @param nval The new string value for this field.
     * @return A boolean, <strong>true</strong> indicates that the field value
     *    has effectively changed.
     * @exception FormFieldException If the provided value didn't match
     *    the expected type for this field.
     */

    public boolean setValue (String nval) 
	throws FormFieldException
    {
	// Unset the value ?
	if ((nval == null) || nval.equals("")) {
	    boolean result = (value != null) ;
	    value = null ;
	    return result ;
	}
	// Did value changed ?
	if ((value != null) && nval.equals(value.getAbsolutePath())) {
	    return false ;
	}
	value = new File(nval) ;
	return true ;
    }

    /**
     * Dump this field has a form element.
     * @param into The HtmlGenerator to dump the field to.
     */

    public void dump (HtmlGenerator into) {
	dumpTitle(into) ;
	into.append ("<th align=left><input type=\"text\""
		     + " name=\""+name+"\""
		     + " size=\"32\""
		     + " value=\""
		     + ((value == null) ? "" : value.getAbsolutePath())
		     + "\"></th>") ;
    }

    /*
     * Initialize a TextField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.value = (File) val ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }

    public FileField (String name, String title, String url, File value) {
	super (name, title, url) ;
	this.value = value ;
    }

    public FileField() {
    }

}
