// Client.java
// $Id: ServerClient.java,v 1.1 1996/07/20 00:03:53 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.daemon;

import java.net.*;
import java.io.*;

public interface ServerClient extends Runnable {

    /**
     * Initialize this client, with the given parameters.
     * @param server The server that created the client.
     * @param factory The factory that created this client.
     * @param id An integer identifing the client.
     */

    public void initialize(ServerHandler hdlr, ClientFactory factory, int id);

    /**
     * Get the server this client is attached to.
     * @return A Server instance, describing the server that created this
     * client.
     */

    public ServerHandler getServerHandler();

    /**
     * Get this client thread.
     * @return The thread running this client, or <strong>null</strong> if no
     * thread has been allocated for this client.
     */

    public Thread getThread();

    /**
     * Get this client identifier.
     * @return The identifier that this client received at initialization time.
     */

    public int getIdentifier();

    /**
     * Emit an error message on behalf of this client.
     * @param msg The message to emit.
     */

    public void error(String msg);

    /**
     * Emit a normal log entry on behalf of this client.
     * @param msg The entry to be logged.
     */

    public void log(String msg);

    /**
     * Emit debugging trace on behalf of this client.
     * @param msg The trace to be emited.
     */
    
    public void trace(String msg) ;

    /**
     * Kill this client.
     * @param force Make all efforts to kill the client right now if
     * <strong>true</strong>, otherwise, shutdown the client gracefully.
     */

    public void kill(boolean force);

    /**
     * Bind this client to the given socket.
     * The factory has been asked to run a client for a newly created
     * connection. It wants to reuse this client instance to handle this new
     * connection.
     * @param socket The socket this client is to handle now.
     */

    public void bind(Socket socket) ;

    /**
     * Get the internet address of the peer this client is handling.
     * This should be used only on bound clients (see the bind method), and
     * returns the IP address of the client's peer.
     * @return An InetAddress instance, or <strong>null</strong> if the client
     * is not currently bound to a socket.
     */

    public InetAddress getInetAddress() ;

    /**
     * Get this client's socket input stream.
     * This should be used only on bound clients (see the bind method). If this
     * method fails, the client is silently killed (unbound) and handed out
     * to the factory as idle.
     * @return An InputStream instance suitable for reading data from
     * the client, or <strong>null</strong> if the client is not bound.
     */

    public InputStream getInputStream();

    /**
     * Get this client's socket output stream.
     * This should be used only on bound clients (see the bind method). If
     * the method fails, the client is silently killed (unbound) and handed
     * out to the factory as idle.
     * @return An OutputStream instance, suitable to send data back to the
     * client, or <strong>null</strong> if the client is not bound.
     */

    public OutputStream getOutputStream();

}
