// CvsHandlerInterface.java
// $Id: CvsHandlerInterface.java,v 1.2 1996/09/11 22:34:13 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.cvs ;

import w3c.jigsaw.http.* ;
import w3c.cvs.* ;

public interface CvsHandlerInterface {

    /**
     * Perform action on the given cvs entry, on behalf of the given client.
     * @param request The request to handle.
     * @param action The action to perform.
     * @param entry The entry to act on.
     * @exception HTTPException If the action couldn't be performed.
     */

    public void perform (Request request, String action, CvsEntry entries[])
	throws HTTPException ;
    
    /**
     * Perform action on the given cvs entry, on behalf of the given client.
     * @param request The request that triggered the processing.
     * @param action The action to perform.
     * @param entry The entry to act on.
     * @param comment Some comments describing your changes.
     * @exception HTTPException If the action couldn't be performed.
     */

    public void perform (Request request
			 , String action
			 , CvsEntry entries[]
			 , String comment)
	throws HTTPException ;
    

}
