/*
 *  UserOptionValue.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: UserOptionValue.java,v 1.1 1997/05/30 13:24:16 bmahe Exp $
 */

package w3c.www.pics;

import java.util.Vector;
import w3c.tools.sexpr.Symbol;

public class UserOptionValue {

  private boolean optional;
  private Object data[];

  public UserOptionValue(Vector parsedData)
    throws PICSParserException
  {
    Symbol key = (Symbol)parsedData.elementAt(0);
    if (key == PICS.OPTIONAL)
      this.optional = true;
    else if (key == PICS.MANDATORY)
      this.optional = false;
    else
      throw new PICSParserException("Extension must be optional or mandatory: "
                                    + key);
    this.data = new Object[parsedData.size() - 2];
    for (int i = 2; i < parsedData.size(); i++)
      data[i - 2] = parsedData.elementAt(i);
  }

  public boolean isOptional()
  {
    return optional;
  }

  public Object[] getData()
  {
    return data;
  }

}
