/*
 *  PICS.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: PICS.java,v 1.1 1997/05/30 13:23:21 bmahe Exp $
 */

package w3c.www.pics;

import java.util.Hashtable;
import w3c.tools.sexpr.Symbol;

public class PICS {

  private static Hashtable symbols = new Hashtable();
  private static Hashtable synonyms = new Hashtable();

  // option labels
  public static final Symbol AT        = sym("at",                symbols);
  public static final Symbol MD5       = sym("md5",               symbols);
  public static final Symbol BY        = sym("by",                symbols);
  public static final Symbol FOR       = sym("for",               symbols);
  public static final Symbol GEN       = sym("gen",               symbols);
  public static final Symbol ON        = sym("on",                symbols);
  public static final Symbol SIGNATURE = sym("signature-RSA-MD5", symbols);
  public static final Symbol EXP       = sym("exp",               symbols);
  public static final Symbol COMMENT   = sym("comment",           symbols);
  public static final Symbol FULL      = sym("full",              symbols);

  // other labels
  public static final Symbol EXTENSION = sym("extension",         symbols);
  public static final Symbol VERS_1_1  = sym("PICS-1.1",          symbols);
  public static final Symbol LABELS    = sym("labels",            symbols);
  public static final Symbol RATINGS   = sym("ratings",           symbols);
  public static final Symbol OPTIONAL  = sym("optional",          symbols);
  public static final Symbol MANDATORY = sym("mandatory",         symbols);
  public static final Symbol TRUE      = sym("true",              symbols);
  public static final Symbol FALSE     = sym("false",             symbols);

  static {

    // synonyms
    symbols.put("mic-md5",        MD5);
    symbols.put("generic",        GEN);
    symbols.put("until",          EXP);
    symbols.put("complete-label", FULL);
    symbols.put("l",              LABELS);
    symbols.put("r",              RATINGS);
    symbols.put("t",              TRUE);
    symbols.put("f",              FALSE);

  }

  public static Hashtable getSymbols()
  {
    return symbols;
  }

  public static Hashtable getSynonyms()
  {
    return synonyms;
  }

  private static Symbol sym(String name, Hashtable st)
  {
    return Symbol.makeSymbol(name, st);
  }

}
