// SimpleResourceStore.java
// $Id: SimpleResourceStore.java,v 1.5 1997/07/30 14:09:56 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.simple;

import java.util.*;
import java.io.*;

import w3c.util.*;
import w3c.tools.resources.*;
import w3c.tools.resources.impl.*;

public class SimpleResourceStore implements ResourceStore {
  
  protected File store = null;

  protected SimpleResourceFilter filter = null;

  public PersistentReference getPersistentReference (String resource) {
    return new PersistentReferenceImpl(store.getAbsolutePath(),resource);
  }

  public Enumeration listResourceName() {
    String childs[] = store.list(filter);
    int i = 0; int idx = 0;
    if ( childs != null ) {
      while (i < childs.length) {
	idx = childs[i].lastIndexOf(".s");
	if (idx != -1) childs[i] = childs[i].substring(0,idx);
	i++;
      }
      return new w3c.util.ArrayEnumeration(childs);
    } else {
      return new w3c.util.EmptyEnumeration();
    }
  }

  public File getResourceFile(String name) {
    return new File(store,name+".s");
  }

  public File getDirectory() {
    return store;
  }

  public ResourceStore addStore(String name) 
    throws ResourceStoreInitException
  {
    return new SimpleResourceStore(new File(store,name));
  }
  
  public ResourceStore getNewStore(File directory)
    throws ResourceStoreInitException
  {
    return new SimpleResourceStore(directory);
  }

  public void init (String init) 
    throws ResourceStoreInitException
  {
    this.store = new File(init);
    if (! store.exists()) store.mkdirs(); 
    if (! store.isDirectory()) 
      throw new ResourceStoreInitException("Can't create "+
					   store.getAbsolutePath());
  }


  public SimpleResourceStore() {
    this.filter = new SimpleResourceFilter();
  }
    

  public SimpleResourceStore(File store) 
    throws ResourceStoreInitException
  { 
    if (! store.exists()) store.mkdirs(); 
    if (! store.isDirectory()) 
      throw new ResourceStoreInitException("Can't create "+
					   store.getAbsolutePath());
    this.store  = store;
    this.filter = new SimpleResourceFilter();
  }

}
