// RemotePropertyDescriptor.java
// $Id: RemotePropertyDescriptor.java,v 1.3 1997/07/30 14:08:58 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.rmi;

import java.beans.PropertyDescriptor;

public class RemotePropertyDescriptor implements java.io.Serializable {
    protected boolean expert = false;
    protected boolean hidden = false;
    protected String  shortDescription = null;
    protected String name = null;
    protected String displayName = null;
    protected Class propertyType = null;
    protected String propertyEditorClassname = null;
    
    private Class convertClass(Class cls) {
	if ( cls == Boolean.TYPE ) {
	    return Boolean.class;
	} else if ( cls == Byte.TYPE ) {
	    return Byte.class;
	} 
	if ( cls == Character.TYPE ) {
	    return Character.class;
	} else if ( cls == Double.TYPE ) {
	    return Double.class;
	} else if ( cls == Float.TYPE ) {
	    return Float.class;
	} else if ( cls == Integer.TYPE ) {
	    return Integer.class;
	} else if ( cls == Long.TYPE ) {
	    return Long.class;
	} else if ( cls == Short.TYPE ) {
	    return Short.class;
	} else if ( cls == Void.TYPE ) {
	    return Void.class;
	} else {
	    return cls;
	}
    }

    public boolean isExpert() {
	return expert;
    }

    public boolean isHidden() {
	return hidden;
    }

    public String getShortDescription() {
	return shortDescription;
    }

    public String getName() {
	return name;
    }

    public String getDisplayName() {
	return displayName;
    }

    public Class getPropertyType() {
	return propertyType;
    }

    protected RemotePropertyDescriptor(PropertyDescriptor p) {
	// Copy p into this:
	this.expert              = p.isExpert();
	this.hidden              = p.isHidden();
	this.shortDescription    = p.getShortDescription();
	this.name                =  p.getName();
	this.displayName         = p.getDisplayName();
	this.propertyType        = convertClass(p.getPropertyType());
	// this.propertyEditorClassname = p.getPropertyEditorClass().getName();
    }

}
