// SampleResourceIndexer.java
// $Id: SampleResourceIndexer.java,v 1.2 1997/07/30 14:08:15 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.indexer;

import java.util.*;
import java.io.*;

import w3c.tools.resources.*;
import w3c.tools.resources.http.*;
import w3c.tools.resources.impl.*;
import w3c.jigsaw.http.*;
//import w3c.tools.store.*;
//import w3c.jigsaw.resources.*;

public class SampleResourceIndexer extends ResourceImpl
                                   implements ResourceIndexer
{
  private static final boolean extCaseSensitive = false;
  private static final String  defname          = "*default*";


  protected long lastModified = -1;

  /**
   * Get this resource last modification time.
   * @return A long giving the date of the last modification time, or
   *    <strong>-1</strong> if undefined.
   */

  public long lastModified() {
    return getLastModified();
  }

  public long getLastModified() {
    return ((Long)holder.protectedGetValue("lastModified")).longValue();
  }

  public void setLastModified(long lastModified) {
    holder.protectedSetValue("lastModified", new Long(lastModified));
  }
  
  public long igetLastModified() {
    return lastModified;
  }

  public void isetLastModified(long lastModified) {
    this.lastModified = lastModified;
  }

  public HTTPResource index(HTTPResourceContext context) 
    throws ResourceInitException
  {
    System.out.println("indexer is indexing...");
    HTTPResource resource = null;
    File file = context.getFile();
    if (! file.exists()) return null;
    if (file.isDirectory()) {
      context.addProperty("directory",file);
      resource = new DirectoryResource();
    }
    else resource = new FileResource();
    return resource;
  }
  
  public SampleResourceIndexer() {
    super();
  }
}
